/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.forge.compat.top;

import com.google.common.base.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.blay09.mods.excompressum.block.AutoHammerBlock;
import net.blay09.mods.excompressum.block.AutoSieveBlock;
import net.blay09.mods.excompressum.block.BaitBlock;
import net.blay09.mods.excompressum.block.HeavySieveBlock;
import net.blay09.mods.excompressum.block.WoodenCrucibleBlock;
import net.blay09.mods.excompressum.block.entity.AbstractAutoSieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.AutoHammerBlockEntity;
import net.blay09.mods.excompressum.block.entity.BaitBlockEntity;
import net.blay09.mods.excompressum.block.entity.EnvironmentalConditionResult;
import net.blay09.mods.excompressum.block.entity.HeavySieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.WoodenCrucibleBlockEntity;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.InterModComms;
import org.jetbrains.annotations.Nullable;

public class TheOneProbeAddon {
    public static void register() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopInitializer::new);
    }

    @Nullable
    private static <T extends BlockEntity> T tryGetTileEntity(Level level, BlockPos pos, Class<T> tileClass) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && tileClass.isAssignableFrom(blockEntity.getClass())) {
            return (T)blockEntity;
        }
        return null;
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider {
        public ResourceLocation getID() {
            return ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"excompressum");
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level level, BlockState state, IProbeHitData data) {
            HeavySieveBlockEntity tileEntity;
            if (state.getBlock() instanceof AutoSieveBlock) {
                AbstractAutoSieveBlockEntity tileEntity2 = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), AbstractAutoSieveBlockEntity.class);
                if (tileEntity2 != null) {
                    this.addAutoSieveInfo(tileEntity2, mode, info);
                }
            } else if (state.getBlock() instanceof AutoHammerBlock) {
                AutoHammerBlockEntity tileEntity3 = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), AutoHammerBlockEntity.class);
                if (tileEntity3 != null) {
                    this.addAutoHammerInfo(tileEntity3, mode, info);
                }
            } else if (state.getBlock() instanceof BaitBlock) {
                BaitBlockEntity tileEntity4 = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), BaitBlockEntity.class);
                if (tileEntity4 != null) {
                    this.addBaitInfo(tileEntity4, mode, info);
                }
            } else if (state.getBlock() instanceof WoodenCrucibleBlock) {
                WoodenCrucibleBlockEntity tileEntity5 = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), WoodenCrucibleBlockEntity.class);
                if (tileEntity5 != null) {
                    this.addWoodenCrucibleInfo(tileEntity5, mode, info);
                }
            } else if (state.getBlock() instanceof HeavySieveBlock && (tileEntity = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), HeavySieveBlockEntity.class)) != null) {
                this.addHeavySieveInfo(tileEntity, mode, info);
            }
        }

        private void addAutoSieveInfo(AbstractAutoSieveBlockEntity tileEntity, ProbeMode mode, IProbeInfo info) {
            if (tileEntity.getSkinProfile() != null) {
                info.text((Component)Component.translatable((String)"tooltip.excompressum.sieveSkin", (Object[])new Object[]{tileEntity.getSkinProfile().partialProfile().name()}));
            }
            if (tileEntity.getFoodBoost() > 1.0f) {
                info.text((Component)Component.translatable((String)"tooltip.excompressum.speedBoost", (Object[])new Object[]{Float.valueOf(tileEntity.getFoodBoost())}));
            }
            if (tileEntity.getEffectiveLuck() > 1.0f) {
                info.text((Component)Component.translatable((String)"tooltip.excompressum.luckBonus", (Object[])new Object[]{Float.valueOf(tileEntity.getEffectiveLuck() - 1.0f)}));
            }
        }

        private void addAutoHammerInfo(AutoHammerBlockEntity tileEntity, ProbeMode mode, IProbeInfo info) {
            if (tileEntity.getEffectiveLuck() > 1.0f) {
                info.text((Component)Component.translatable((String)"tooltip.excompressum.luckBonus", (Object[])new Object[]{Float.valueOf(tileEntity.getEffectiveLuck() - 1.0f)}));
            }
        }

        private void addBaitInfo(BaitBlockEntity tileEntity, ProbeMode mode, IProbeInfo info) {
            EnvironmentalConditionResult environmentalStatus = tileEntity.checkSpawnConditions(true);
            if (environmentalStatus == EnvironmentalConditionResult.CanSpawn) {
                info.text((Component)Component.translatable((String)"tooltip.excompressum.baitTooClose"));
                info.text((Component)Component.translatable((String)"tooltip.excompressum.baitTooClose2"));
            } else {
                MutableComponent statusText = Component.translatable((String)environmentalStatus.langKey, (Object[])environmentalStatus.params);
                statusText.withStyle(ChatFormatting.RED);
                info.text((Component)statusText);
            }
        }

        private void addWoodenCrucibleInfo(WoodenCrucibleBlockEntity tileEntity, ProbeMode mode, IProbeInfo info) {
            if ((float)tileEntity.getSolidVolume() > 0.0f) {
                info.text((Component)Component.translatable((String)"tooltip.excompressum.solidVolume", (Object[])new Object[]{tileEntity.getSolidVolume()}));
            }
            if ((float)tileEntity.getFluidTank().getAmount() > 0.0f) {
                info.text((Component)Component.translatable((String)"tooltip.excompressum.fluidVolume", (Object[])new Object[]{tileEntity.getFluidTank().getAmount()}));
            }
        }

        private void addHeavySieveInfo(HeavySieveBlockEntity tileEntity, ProbeMode mode, IProbeInfo info) {
            ItemStack meshStack;
            if (tileEntity.getProgress() > 0.0f) {
                info.text((Component)Component.translatable((String)"tooltip.excompressum.sieveProgress", (Object[])new Object[]{(int)(tileEntity.getProgress() * 100.0f) + "%"}));
            }
            if (!(meshStack = tileEntity.getMeshStack()).isEmpty()) {
                if (ExNihilo.getInstance().doMeshesHaveDurability()) {
                    info.text((Component)Component.translatable((String)"tooltip.excompressum.sieveMesh", (Object[])new Object[]{meshStack.getDisplayName(), meshStack.getMaxDamage() - meshStack.getDamageValue(), meshStack.getMaxDamage()}));
                } else {
                    info.text(meshStack.getDisplayName());
                }
            } else {
                info.text((Component)Component.translatable((String)"tooltip.excompressum.sieveNoMesh"));
            }
        }
    }

    public static class TopInitializer
    implements Function<ITheOneProbe, Void> {
        @Nullable
        public Void apply(@Nullable ITheOneProbe top) {
            if (top != null) {
                top.registerProvider((IProbeInfoProvider)new ProbeInfoProvider());
            }
            return null;
        }
    }
}

