/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.handler;

import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.excompressum.tag.ModBlockTags;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;

public class HammerSpeedHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(DigSpeedEvent.class, HammerSpeedHandler::onDigSpeed);
    }

    public static void onDigSpeed(DigSpeedEvent event) {
        Tool tool;
        ItemStack heldItem = event.getPlayer().getItemInHand(InteractionHand.MAIN_HAND);
        if ((heldItem.is(ModItemTags.HAMMERS) || heldItem.is(ModItemTags.COMPRESSED_HAMMERS)) && event.getState().is(ModBlockTags.MINEABLE_WITH_HAMMER) && (tool = (Tool)heldItem.get(DataComponents.TOOL)) != null) {
            Optional<Float> bestSpeed = tool.rules().stream().map(it -> it.speed().orElse(Float.valueOf(0.0f))).max(Float::compare);
            event.setSpeedOverride(bestSpeed.orElse(Float.valueOf(tool.defaultMiningSpeed())));
        }
    }
}

