/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.item;

import java.util.List;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.component.ModComponents;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.tag.ModBlockTags;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class ChickenStickItem
extends Item {
    public static final ToolMaterial CHICKEN_STICK_TIER = new ToolMaterial(ModBlockTags.INCORRECT_FOR_CHICKEN_STICK, 0, ToolMaterial.DIAMOND.speed(), 0.0f, 1, ModItemTags.CHICKEN_STICK_TOOL_MATERIALS);

    public ChickenStickItem(Item.Properties properties) {
        super(properties.fireResistant());
    }

    public void hurtEnemy(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        this.tryPlayChickenSound((LevelAccessor)attacker.level(), attacker.blockPosition());
        super.hurtEnemy(itemStack, attacker, target);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        this.tryPlayChickenSound((LevelAccessor)level, player.blockPosition());
        player.swing(hand);
        return InteractionResult.SUCCESS;
    }

    public void tryPlayChickenSound(LevelAccessor level, BlockPos pos) {
        if ((double)level.getRandom().nextFloat() <= ExCompressumConfig.getActive().tools.chickenStickSoundChance) {
            ResourceLocation location = null;
            List<String> chickenStickSounds = ExCompressumConfig.getActive().tools.chickenStickSounds;
            if (!chickenStickSounds.isEmpty()) {
                location = ResourceLocation.parse((String)chickenStickSounds.get(level.getRandom().nextInt(chickenStickSounds.size())));
            }
            if (location != null) {
                SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(location);
                if (soundEvent != null) {
                    level.playSound(null, pos, soundEvent, SoundSource.PLAYERS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
                } else {
                    ExCompressum.logger.warn("Chicken Stick tried to play a sound that does not exist: {}", (Object)location);
                }
            }
        }
    }

    public boolean isFoil(ItemStack stack) {
        return this.isAngry(stack);
    }

    public boolean isAngry(ItemStack itemStack) {
        return itemStack.has((DataComponentType)ModComponents.angry.get());
    }
}

