/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.loot;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.excompressum.loot.LootTableEntry;
import net.blay09.mods.excompressum.loot.MergedLootTableEntry;
import net.blay09.mods.excompressum.mixin.BinomialDistributionGeneratorAccessor;
import net.blay09.mods.excompressum.mixin.ConstantValueAccessor;
import net.blay09.mods.excompressum.mixin.LootItemAccessor;
import net.blay09.mods.excompressum.mixin.LootItemRandomChanceConditionAccessor;
import net.blay09.mods.excompressum.mixin.LootPoolAccessor;
import net.blay09.mods.excompressum.mixin.LootPoolEntryContainerAccessor;
import net.blay09.mods.excompressum.mixin.LootPoolSingletonContainerAccessor;
import net.blay09.mods.excompressum.mixin.LootTableAccessor;
import net.blay09.mods.excompressum.mixin.SetItemCountFunctionAccessor;
import net.blay09.mods.excompressum.mixin.TagEntryAccessor;
import net.blay09.mods.excompressum.mixin.UniformGeneratorAccessor;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.Nullable;

public class LootTableUtils {
    private static final ContextKey<ItemStack> SOURCE_STACK = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"source_stack"));
    private static final ContextKeySet CONTEXT_KEY_SET = new ContextKeySet.Builder().required(SOURCE_STACK).build();

    public static boolean isLootTableEmpty(@Nullable LootTable lootTable) {
        if (lootTable == null) {
            return true;
        }
        return LootTableUtils.getLootTableEntries(lootTable).isEmpty();
    }

    public static List<LootTableEntry> getLootTableEntries(@Nullable LootTable lootTable) {
        if (lootTable == null) {
            return Collections.emptyList();
        }
        ArrayList<LootTableEntry> result = new ArrayList<LootTableEntry>();
        List<LootPool> pools = ((LootTableAccessor)lootTable).getPools();
        for (LootPool pool : pools) {
            Optional<NumberProvider> poolBaseChance = LootTableUtils.getBaseChance(pool);
            List<LootPoolEntryContainer> entries = ((LootPoolAccessor)pool).getEntries();
            for (LootPoolEntryContainer entry : entries) {
                Optional<NumberProvider> entryBaseChance = LootTableUtils.getBaseChance(entry);
                NumberProvider baseChance = entryBaseChance.orElse(poolBaseChance.orElseGet(() -> ConstantValue.exactly((float)1.0f)));
                NumberProvider countRange = LootTableUtils.getCountRange(entry);
                if (entry instanceof LootItemAccessor) {
                    LootItemAccessor lootItem = (LootItemAccessor)entry;
                    ItemStack itemStack = new ItemStack(lootItem.getItem());
                    itemStack.setCount(Math.max(1, (int)LootTableUtils.getMaxCount(countRange)));
                    result.add(new LootTableEntry(itemStack, countRange, baseChance));
                    continue;
                }
                if (!(entry instanceof TagEntryAccessor)) continue;
                TagEntryAccessor tagEntry = (TagEntryAccessor)entry;
                TagKey<Item> tag = tagEntry.getTag();
                BuiltInRegistries.ITEM.getTagOrEmpty(tag).forEach(itemHolder -> {
                    ItemStack itemStack = new ItemStack((ItemLike)itemHolder.value());
                    itemStack.setCount(Math.max(1, (int)LootTableUtils.getMaxCount(countRange)));
                    result.add(new LootTableEntry(itemStack, countRange, baseChance));
                });
            }
        }
        return result;
    }

    private static Optional<NumberProvider> getBaseChance(LootPool pool) {
        return LootTableUtils.getBaseChance(((LootPoolAccessor)pool).getConditions());
    }

    private static Optional<NumberProvider> getBaseChance(LootPoolEntryContainer entry) {
        return LootTableUtils.getBaseChance(((LootPoolEntryContainerAccessor)entry).getConditions());
    }

    private static Optional<NumberProvider> getBaseChance(List<LootItemCondition> conditions) {
        for (LootItemCondition condition : conditions) {
            if (!(condition instanceof LootItemRandomChanceConditionAccessor)) continue;
            LootItemRandomChanceConditionAccessor chanceCondition = (LootItemRandomChanceConditionAccessor)condition;
            return Optional.of(chanceCondition.getChance());
        }
        return Optional.empty();
    }

    private static NumberProvider getCountRange(LootPoolEntryContainer entry) {
        if (entry instanceof LootPoolSingletonContainerAccessor) {
            LootPoolSingletonContainerAccessor lootPoolSingletonContainer = (LootPoolSingletonContainerAccessor)entry;
            for (LootItemFunction function : lootPoolSingletonContainer.getFunctions()) {
                if (!(function instanceof SetItemCountFunctionAccessor)) continue;
                SetItemCountFunctionAccessor setItemCountFunction = (SetItemCountFunctionAccessor)function;
                return setItemCountFunction.getValue();
            }
        }
        return ConstantValue.exactly((float)1.0f);
    }

    public static float getMinCount(NumberProvider range) {
        if (range instanceof UniformGeneratorAccessor) {
            UniformGeneratorAccessor uniform = (UniformGeneratorAccessor)range;
            return LootTableUtils.getMinCount(uniform.getMin());
        }
        if (range instanceof BinomialDistributionGeneratorAccessor) {
            BinomialDistributionGeneratorAccessor binomial = (BinomialDistributionGeneratorAccessor)range;
            return LootTableUtils.getMinCount(binomial.getN()) * LootTableUtils.getMaxCount(binomial.getP());
        }
        if (range instanceof ConstantValueAccessor) {
            ConstantValueAccessor constant = (ConstantValueAccessor)range;
            return constant.getValue();
        }
        return 1.0f;
    }

    public static float getMaxCount(NumberProvider range) {
        if (range instanceof UniformGeneratorAccessor) {
            UniformGeneratorAccessor uniform = (UniformGeneratorAccessor)range;
            return LootTableUtils.getMaxCount(uniform.getMax());
        }
        if (range instanceof BinomialDistributionGeneratorAccessor) {
            BinomialDistributionGeneratorAccessor binomial = (BinomialDistributionGeneratorAccessor)range;
            return LootTableUtils.getMaxCount(binomial.getN()) * LootTableUtils.getMaxCount(binomial.getP());
        }
        if (range instanceof ConstantValueAccessor) {
            ConstantValueAccessor constant = (ConstantValueAccessor)range;
            return constant.getValue();
        }
        return 1.0f;
    }

    public static LootContext buildLootContext(ServerLevel level, ItemStack itemStack) {
        ContextMap.Builder params = new ContextMap.Builder();
        params.withParameter(SOURCE_STACK, (Object)itemStack);
        return new LootContext.Builder(new LootParams(level, params.create(CONTEXT_KEY_SET), Collections.emptyMap(), 0.0f)).create(Optional.empty());
    }

    public static List<MergedLootTableEntry> mergeLootTableEntries(List<LootTableEntry> entries) {
        ArrayList<MergedLootTableEntry> result = new ArrayList<MergedLootTableEntry>();
        ArrayListMultimap entryMap = ArrayListMultimap.create();
        for (LootTableEntry entry : entries) {
            if (!entry.getItemStack().getComponents().isEmpty()) {
                result.add(new MergedLootTableEntry(entry));
                continue;
            }
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)entry.getItemStack().getItem());
            entryMap.put((Object)itemId, (Object)entry);
        }
        for (ResourceLocation key : entryMap.keySet()) {
            List mergableEntries = entryMap.get((Object)key);
            LootTableEntry firstEntry = (LootTableEntry)mergableEntries.getFirst();
            result.add(new MergedLootTableEntry(firstEntry.getItemStack(), mergableEntries));
        }
        return result;
    }

    public static LootPoolSingletonContainer.Builder<?> buildLootEntry(ItemStack outputItem, float chance) {
        LootPoolSingletonContainer.Builder entryBuilder = LootItem.lootTableItem((ItemLike)outputItem.getItem());
        if (outputItem.getCount() > 0) {
            entryBuilder.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)outputItem.getCount())));
        }
        for (TypedDataComponent component : outputItem.getComponents()) {
            entryBuilder.apply(LootTableUtils.copyComponent(component));
        }
        if (chance != -1.0f) {
            entryBuilder.when(LootItemRandomChanceCondition.randomChance((float)chance));
        }
        return entryBuilder;
    }

    public static LootPoolSingletonContainer.Builder<?> buildLootEntry(ItemStack itemStack, NumberProvider amount) {
        LootPoolSingletonContainer.Builder entryBuilder = LootItem.lootTableItem((ItemLike)itemStack.getItem());
        if (itemStack.getCount() > 0) {
            entryBuilder.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)amount));
        }
        for (TypedDataComponent component : itemStack.getComponents()) {
            entryBuilder.apply(LootTableUtils.copyComponent(component));
        }
        return entryBuilder;
    }

    private static <T> LootItemConditionalFunction.Builder<?> copyComponent(TypedDataComponent<T> component) {
        return SetComponentsFunction.setComponent((DataComponentType)component.type(), (Object)component.value());
    }
}

