/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.compressedhammer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.excompressum.api.recipe.CompressedHammerRecipe;
import net.blay09.mods.excompressum.mixin.RecipeManagerAccessor;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.ModRecipeTypes;
import net.blay09.mods.excompressum.registry.compressedhammer.CompressedHammerRecipeImpl;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;

public class CompressedHammerRegistry {
    public static List<ItemStack> rollHammerRewards(ServerLevel level, LootContext context, ItemStack itemStack) {
        RecipeManager recipeManager = level.getServer().getRecipeManager();
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.byType(ModRecipeTypes.compressedHammerRecipeType);
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (RecipeHolder recipeHolder : recipes) {
            LootTable lootTable;
            CompressedHammerRecipeImpl recipe = (CompressedHammerRecipeImpl)recipeHolder.value();
            if (!CompressedHammerRegistry.testRecipe(itemStack, recipe) || (lootTable = recipe.getLootTable()) == null) continue;
            lootTable.getRandomItems(context, results::add);
        }
        results.addAll(ExNihilo.getInstance().rollCompressedHammerRewards((Level)level, context, itemStack));
        return results;
    }

    private static boolean testRecipe(ItemStack itemStack, CompressedHammerRecipe recipe) {
        return recipe.getIngredient().test(itemStack);
    }

    public boolean isHammerable(ServerLevel level, ItemStack itemStack) {
        return this.isHammerable(level.getServer().getRecipeManager(), itemStack);
    }

    public boolean isHammerable(RecipeManager recipeManager, ItemStack itemStack) {
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.byType(ModRecipeTypes.compressedHammerRecipeType);
        for (RecipeHolder recipeHolder : recipes) {
            CompressedHammerRecipeImpl recipe = (CompressedHammerRecipeImpl)recipeHolder.value();
            if (!CompressedHammerRegistry.testRecipe(itemStack, recipe)) continue;
            return true;
        }
        return ExNihilo.getInstance().isHammerableCompressed(itemStack);
    }
}

