/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.heavysieve;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.blay09.mods.excompressum.api.recipe.HeavySieveRecipe;
import net.blay09.mods.excompressum.api.sievemesh.CommonMeshType;
import net.blay09.mods.excompressum.registry.ExCompressumRecipe;
import net.blay09.mods.excompressum.registry.ExCompressumSerializers;
import net.blay09.mods.excompressum.registry.ModRecipeTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.storage.loot.LootTable;

public class HeavySieveRecipeImpl
extends ExCompressumRecipe<RecipeInput>
implements HeavySieveRecipe {
    private final Ingredient ingredient;
    private final LootTable lootTable;
    private final boolean waterlogged;
    private final Set<CommonMeshType> meshes;

    public HeavySieveRecipeImpl(Ingredient ingredient, LootTable lootTable, boolean waterlogged, List<CommonMeshType> meshes) {
        this.ingredient = ingredient;
        this.lootTable = lootTable;
        this.waterlogged = waterlogged;
        this.meshes = Set.copyOf(meshes);
    }

    public RecipeSerializer<HeavySieveRecipeImpl> getSerializer() {
        return ModRecipeTypes.heavySieveRecipeSerializer;
    }

    public RecipeType<HeavySieveRecipeImpl> getType() {
        return ModRecipeTypes.heavySieveRecipeType;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create((Ingredient)this.ingredient);
    }

    public RecipeBookCategory recipeBookCategory() {
        return ModRecipeTypes.heavySieveRecipeBookCategory;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public LootTable getLootTable() {
        return this.lootTable;
    }

    @Override
    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    @Override
    public Set<CommonMeshType> getMeshes() {
        return this.meshes;
    }

    public List<CommonMeshType> getMeshesList() {
        return List.copyOf(this.meshes);
    }

    public static class Serializer
    implements RecipeSerializer<HeavySieveRecipeImpl> {
        private static final MapCodec<HeavySieveRecipeImpl> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(recipe -> recipe.ingredient), (App)LootTable.DIRECT_CODEC.fieldOf("lootTable").forGetter(recipe -> recipe.lootTable), (App)Codec.BOOL.fieldOf("waterlogged").forGetter(recipe -> recipe.waterlogged), (App)CommonMeshType.CODEC.listOf().fieldOf("meshes").forGetter(recipe -> List.copyOf(recipe.meshes))).apply((Applicative)instance, HeavySieveRecipeImpl::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, HeavySieveRecipeImpl> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, HeavySieveRecipeImpl::getIngredient, ExCompressumSerializers.LOOT_TABLE_STREAM_CODEC, HeavySieveRecipeImpl::getLootTable, (StreamCodec)ByteBufCodecs.BOOL, HeavySieveRecipeImpl::isWaterlogged, CommonMeshType.LIST_STREAM_CODEC, HeavySieveRecipeImpl::getMeshesList, HeavySieveRecipeImpl::new);

        public MapCodec<HeavySieveRecipeImpl> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HeavySieveRecipeImpl> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

