/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.DelegateContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.block.AutoSieveBaseBlock;
import net.blay09.mods.excompressum.block.ModBlockStateProperties;
import net.blay09.mods.excompressum.block.entity.AbstractBaseBlockEntity;
import net.blay09.mods.excompressum.block.entity.SieveAnimationType;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.menu.AutoSieveMenu;
import net.blay09.mods.excompressum.menu.ModMenus;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.autosieveskin.AutoSieveSkinRegistry;
import net.blay09.mods.excompressum.registry.autosieveskin.WhitelistEntry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_4174;
import net.minecraft.class_5819;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9296;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAutoSieveBlockEntity
extends AbstractBaseBlockEntity
implements BalmMenuProvider<class_2338>,
BalmContainerProvider {
    private static final int UPDATE_INTERVAL = 20;
    private static final int PARTICLE_TICKS = 30;
    private final DefaultContainer backingContainer = new DefaultContainer(22){

        public boolean method_5437(int slot, class_1799 itemStack) {
            if (AbstractAutoSieveBlockEntity.this.inputSlots.containsOuterSlot(slot)) {
                class_3218 serverLevel;
                class_1937 class_19372 = AbstractAutoSieveBlockEntity.this.field_11863;
                return class_19372 instanceof class_3218 && AbstractAutoSieveBlockEntity.this.isSiftableWithMesh(serverLevel = (class_3218)class_19372, itemStack, AbstractAutoSieveBlockEntity.this.getSieveMesh());
            }
            if (AbstractAutoSieveBlockEntity.this.meshSlots.containsOuterSlot(slot)) {
                return AbstractAutoSieveBlockEntity.this.isMesh(itemStack);
            }
            return true;
        }

        public void slotChanged(int slot) {
            super.slotChanged(slot);
            class_1937 class_19372 = AbstractAutoSieveBlockEntity.this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                AbstractAutoSieveBlockEntity.this.updateCorrectSieveMesh(serverLevel);
            }
            if (AbstractAutoSieveBlockEntity.this.meshSlots.containsOuterSlot(slot)) {
                AbstractAutoSieveBlockEntity.this.isDirty = true;
            }
        }
    };
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int id) {
            if (id == 0) {
                return (int)(100.0f * AbstractAutoSieveBlockEntity.this.getProgress());
            }
            if (id == 1) {
                return AbstractAutoSieveBlockEntity.this.getEnergyStored();
            }
            if (id == 2) {
                return AbstractAutoSieveBlockEntity.this.isDisabledByRedstone() ? 1 : 0;
            }
            if (id == 3) {
                return AbstractAutoSieveBlockEntity.this.isCorrectSieveMesh() ? 1 : 0;
            }
            return 0;
        }

        public void method_17391(int id, int value) {
            if (id == 0) {
                AbstractAutoSieveBlockEntity.this.setProgress((float)value / 100.0f);
            } else if (id == 1) {
                AbstractAutoSieveBlockEntity.this.setEnergyStored(value);
            } else if (id == 2) {
                AbstractAutoSieveBlockEntity.this.setDisabledByRedstone(value == 1);
            } else if (id == 3) {
                AbstractAutoSieveBlockEntity.this.setCorrectSieveMesh(value == 1);
            }
        }

        public int method_17389() {
            return 4;
        }
    };
    private final SubContainer inputSlots = new SubContainer((class_1263)this.backingContainer, 0, 1);
    private final SubContainer outputSlots = new SubContainer((class_1263)this.backingContainer, 1, 21);
    private final SubContainer meshSlots = new SubContainer((class_1263)this.backingContainer, 21, 22);
    private final List<class_1799> overflowBuffer = new ArrayList<class_1799>();
    private final DelegateContainer container = new DelegateContainer((class_1263)this.backingContainer){

        public boolean method_5437(int slot, class_1799 itemStack) {
            return super.method_5437(slot, itemStack) && (AbstractAutoSieveBlockEntity.this.inputSlots.containsOuterSlot(slot) || AbstractAutoSieveBlockEntity.this.meshSlots.containsOuterSlot(slot));
        }

        public int[] method_5494(class_2350 direction) {
            if (direction == class_2350.field_11033) {
                return AbstractAutoSieveBlockEntity.this.outputSlots.getOuterSlotsForFace(direction);
            }
            if (direction == class_2350.field_11036) {
                return AbstractAutoSieveBlockEntity.this.inputSlots.getOuterSlotsForFace(direction);
            }
            return AbstractAutoSieveBlockEntity.this.meshSlots.getOuterSlotsForFace(direction);
        }

        public boolean method_5493(int slot, class_1799 itemStack, class_2350 direction) {
            return AbstractAutoSieveBlockEntity.this.outputSlots.containsOuterSlot(slot);
        }
    };
    private class_1799 currentStack = class_1799.field_8037;
    private class_9296 skinProfile;
    private int ticksSinceSync;
    protected boolean isDirty;
    private float progress;
    private float foodBoost;
    private int foodBoostTicks;
    public float armAngle;
    private int particleTicks;
    private int particleCount;
    private boolean correctSieveMesh;
    private boolean isDisabledByRedstone;

    public AbstractAutoSieveBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, AbstractAutoSieveBlockEntity blockEntity) {
        blockEntity.clientTick();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, AbstractAutoSieveBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void clientTick() {
        if (this.particleTicks > 0) {
            class_2680 processingState;
            --this.particleTicks;
            if (this.particleTicks <= 0) {
                this.particleCount = 0;
            }
            if (!(this.currentStack.method_7960() || this.isUgly() || (processingState = StupidUtils.getStateFromItemStack(this.currentStack)).method_26215())) {
                ExCompressum.proxy.get().spawnAutoSieveParticles(this.field_11863, this.field_11867, this.method_11010(), processingState, this.particleCount);
            }
        }
    }

    public void serverTick() {
        if (this.foodBoostTicks > 0) {
            --this.foodBoostTicks;
            if (this.foodBoostTicks <= 0) {
                this.foodBoost = 0.0f;
            }
        }
        ++this.ticksSinceSync;
        if (this.ticksSinceSync > 20) {
            if (this.isDirty) {
                this.method_5431();
                this.sync();
                this.isDirty = false;
            }
            this.ticksSinceSync = 0;
        }
        int effectiveEnergy = this.getEffectiveEnergy();
        if (!this.isDisabledByRedstone() && this.overflowBuffer.isEmpty() && this.getEnergyStored() >= effectiveEnergy) {
            if (this.currentStack.method_7960()) {
                class_1799 inputStack = this.inputSlots.method_5438(0);
                SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
                if (!inputStack.method_7960() && sieveMesh != null && this.isSiftableWithMesh((class_3218)this.field_11863, inputStack, sieveMesh)) {
                    boolean foundSpace = false;
                    for (int i = 0; i < this.outputSlots.method_5439(); ++i) {
                        if (!this.outputSlots.method_5438(i).method_7960()) continue;
                        foundSpace = true;
                    }
                    if (!foundSpace) {
                        return;
                    }
                    this.currentStack = inputStack.method_7971(1);
                    if (inputStack.method_7960()) {
                        this.inputSlots.method_5447(0, class_1799.field_8037);
                    }
                    this.drainEnergy(effectiveEnergy, false);
                    this.sync();
                    this.progress = 0.0f;
                }
            } else {
                this.drainEnergy(effectiveEnergy, false);
                this.progress += this.getEffectiveSpeed();
                this.particleTicks = 30;
                this.particleCount = (int)this.getSpeedMultiplier();
                this.isDirty = true;
                if (this.progress >= 1.0f) {
                    if (!this.field_11863.method_8608()) {
                        SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
                        if (sieveMesh != null) {
                            class_1799 meshStack;
                            Collection<class_1799> rewards = this.rollSieveRewards((class_3218)this.field_11863, this.currentStack, sieveMesh, this.getEffectiveLuck(), this.field_11863.field_9229);
                            for (class_1799 itemStack : rewards) {
                                if (this.addItemToOutput(itemStack)) continue;
                                this.overflowBuffer.add(itemStack);
                            }
                            if (ExNihilo.getInstance().doMeshesHaveDurability() && !(meshStack = this.meshSlots.method_5438(0)).method_7960()) {
                                meshStack.method_7956(1, (class_3218)this.field_11863, null, it -> {
                                    this.field_11863.method_8396(null, this.field_11867, (class_3414)class_3417.field_15075.comp_349(), class_3419.field_15245, 0.5f, 2.5f);
                                    meshStack.method_7934(1);
                                    this.meshSlots.method_5447(0, class_1799.field_8037);
                                });
                            }
                        } else if (!this.addItemToOutput(this.currentStack)) {
                            this.overflowBuffer.add(this.currentStack);
                        }
                    }
                    this.progress = 0.0f;
                    this.currentStack = class_1799.field_8037;
                }
            }
        } else if (!this.overflowBuffer.isEmpty() && this.addItemToOutput(this.overflowBuffer.get(0))) {
            this.overflowBuffer.remove(0);
        }
    }

    protected abstract int drainEnergy(int var1, boolean var2);

    private boolean addItemToOutput(class_1799 itemStack) {
        int firstEmptySlot = -1;
        for (int i = 0; i < this.outputSlots.method_5439(); ++i) {
            class_1799 slotStack = this.outputSlots.method_5438(i);
            if (slotStack.method_7960()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (slotStack.method_7947() + itemStack.method_7947() > slotStack.method_7914() || !class_1799.method_31577((class_1799)slotStack, (class_1799)itemStack)) continue;
            slotStack.method_7933(itemStack.method_7947());
            return true;
        }
        if (firstEmptySlot != -1) {
            this.outputSlots.method_5447(firstEmptySlot, itemStack);
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ExCompressumConfig.getActive().automation.autoSieveEnergy;
    }

    public float getEffectiveSpeed() {
        return (float)(ExCompressumConfig.getActive().automation.autoSieveSpeed * (double)this.getSpeedMultiplier());
    }

    public float getEffectiveLuck() {
        class_1799 meshStack = this.meshSlots.method_5438(0);
        if (!meshStack.method_7960()) {
            return ExNihilo.getInstance().getMeshFortune(meshStack);
        }
        return 0.0f;
    }

    public boolean isSiftableWithMesh(class_3218 level, class_1799 itemStack, @Nullable SieveMeshRegistryEntry sieveMesh) {
        return ExNihilo.isSiftableWithMesh((class_1937)level, this.method_11010(), itemStack, sieveMesh);
    }

    private boolean isMesh(class_1799 itemStack) {
        return SieveMeshRegistry.getEntry(itemStack) != null;
    }

    public Collection<class_1799> rollSieveRewards(class_3218 level, class_1799 itemStack, SieveMeshRegistryEntry sieveMesh, float luck, class_5819 rand) {
        return ExNihilo.rollSieveRewards((class_1937)level, this.method_11010(), itemStack, sieveMesh, luck, rand);
    }

    public void method_11014(class_11368 input) {
        this.currentStack = input.method_71426("CurrentStack", class_1799.field_49266).orElse(class_1799.field_8037);
        this.progress = input.method_71423("Progress", 0.0f);
        input.method_71426("CustomSkin", class_9296.field_49359).ifPresent(this::setSkinProfile);
        this.foodBoost = input.method_71423("FoodBoost", 0.0f);
        this.foodBoostTicks = input.method_71424("FoodBoostTicks", 0);
        this.particleTicks = input.method_71424("ParticleTicks", 0);
        this.particleCount = input.method_71424("ParticleCount", 0);
        input.method_71420("ItemHandler").ifPresent(it -> class_1262.method_5429((class_11368)it, (class_2371)this.backingContainer.getItems()));
        this.isDisabledByRedstone = input.method_71433("IsDisabledByRedstone", false);
        this.overflowBuffer.clear();
        input.method_71435("OverflowBuffer", class_1799.field_24671).ifPresent(overflowItems -> {
            for (class_1799 overflowItem : overflowItems) {
                this.overflowBuffer.add(overflowItem);
            }
        });
        input.method_71426("MeshStack", class_1799.field_49266).ifPresent(meshStack -> this.meshSlots.method_5447(0, meshStack));
    }

    public void method_11007(class_11372 output) {
        output.method_71468("CurrentStack", class_1799.field_49266, (Object)this.currentStack);
        output.method_71464("Progress", this.progress);
        output.method_71477("CustomSkin", class_9296.field_49359, (Object)this.skinProfile);
        output.method_71464("FoodBoost", this.foodBoost);
        output.method_71465("FoodBoostTicks", this.foodBoostTicks);
        output.method_71465("ParticleTicks", this.particleTicks);
        output.method_71465("ParticleCount", this.particleCount);
        class_1262.method_5426((class_11372)output.method_71461("ItemHandler"), (class_2371)this.backingContainer.getItems());
        output.method_71472("IsDisabledByRedstone", this.isDisabledByRedstone());
        class_11372.class_11373 overflowList = output.method_71467("OverflowBuffer", class_1799.field_24671);
        for (class_1799 itemStack : this.overflowBuffer) {
            overflowList.method_71484((Object)itemStack);
        }
    }

    public void writeUpdateTag(class_11372 output) {
        this.method_11007(output);
        class_1799 meshStack = this.meshSlots.method_5438(0);
        output.method_71468("MeshStack", class_1799.field_49266, (Object)meshStack);
    }

    public float getEnergyPercentage() {
        return (float)this.getEnergyStored() / (float)this.getMaxEnergyStored();
    }

    public abstract int getEnergyStored();

    public abstract void setEnergyStored(int var1);

    public abstract int getMaxEnergyStored();

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public class_1799 getCurrentStack() {
        return this.currentStack;
    }

    public void setSkinProfile(@Nullable class_9296 skinProfile) {
        this.skinProfile = skinProfile;
        this.isDirty = true;
        this.method_5431();
    }

    @Nullable
    public class_9296 getSkinProfile() {
        return this.skinProfile;
    }

    public float getSpeedMultiplier() {
        float EFFICIENCY_BOOST = 0.25f;
        float boost = 1.0f;
        class_1799 meshStack = this.meshSlots.method_5438(0);
        if (!meshStack.method_7960()) {
            boost += 0.25f * (float)ExNihilo.getInstance().getMeshEfficiency(meshStack);
        }
        return boost * this.getFoodBoost();
    }

    public float getFoodBoost() {
        return 1.0f + this.foodBoost;
    }

    public void setFoodBoost(int foodBoostTicks, float foodBoost) {
        this.foodBoostTicks = foodBoostTicks;
        this.foodBoost = foodBoost;
        this.isDirty = true;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    @Nullable
    public SieveMeshRegistryEntry getSieveMesh() {
        class_1799 meshStack = this.meshSlots.method_5438(0);
        if (!meshStack.method_7960()) {
            return SieveMeshRegistry.getEntry(meshStack);
        }
        return null;
    }

    public class_1799 getMeshStack() {
        return this.meshSlots.method_5438(0);
    }

    public void updateCorrectSieveMesh(class_3218 level) {
        class_1799 inputStack = this.inputSlots.method_5438(0);
        SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
        this.correctSieveMesh = inputStack.method_7960() || sieveMesh == null || this.isSiftableWithMesh(level, inputStack, sieveMesh);
    }

    public void setCorrectSieveMesh(boolean correctSieveMesh) {
        this.correctSieveMesh = correctSieveMesh;
    }

    public boolean isCorrectSieveMesh() {
        return this.correctSieveMesh;
    }

    public boolean shouldAnimate() {
        return !this.currentStack.method_7960() && this.getEnergyStored() >= this.getEffectiveEnergy() && !this.isDisabledByRedstone();
    }

    public boolean isUgly() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)ModBlockStateProperties.UGLY)) {
            return (Boolean)state.method_11654((class_2769)ModBlockStateProperties.UGLY);
        }
        return false;
    }

    public boolean isWaterlogged() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)AutoSieveBaseBlock.WATERLOGGED)) {
            return (Boolean)state.method_11654((class_2769)AutoSieveBaseBlock.WATERLOGGED);
        }
        return false;
    }

    public boolean isDisabledByRedstone() {
        return this.isDisabledByRedstone;
    }

    public void setDisabledByRedstone(boolean disabledByRedstone) {
        this.isDisabledByRedstone = disabledByRedstone;
        this.isDirty = true;
        this.ticksSinceSync = 20;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.excompressum.auto_sieve");
    }

    public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
        return new AutoSieveMenu((class_3917<AutoSieveMenu>)((class_3917)ModMenus.autoSieve.get()), windowId, inventory, this);
    }

    public SieveAnimationType getAnimationType() {
        return SieveAnimationType.DEFAULT;
    }

    public void applyFoodBoost(class_4174 food) {
        int foodBoostTicks = (int)food.comp_2492() * 640;
        if (foodBoostTicks <= 0) {
            foodBoostTicks = 640;
        }
        float foodBoost = Math.max(1.0f, (float)food.comp_2491() * 0.75f);
        this.setFoodBoost(foodBoostTicks, foodBoost);
    }

    public class_1263 getBackingContainer() {
        return this.backingContainer;
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public class_3913 getContainerData() {
        return this.containerData;
    }

    protected void method_57568(class_9473 input) {
        class_9296 profile = (class_9296)input.method_58694(class_9334.field_49617);
        if (profile == null) {
            WhitelistEntry randomSkin = AutoSieveSkinRegistry.getRandomSkin();
            if (randomSkin != null) {
                this.setSkinProfile(class_9296.method_73312((UUID)randomSkin.getUuid()));
            }
        } else {
            this.setSkinProfile(profile);
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        if (this.skinProfile != null) {
            builder.method_57840(class_9334.field_49617, (Object)this.skinProfile);
        }
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayer) {
        return this.field_11867;
    }

    public class_9139<class_9129, class_2338> getScreenStreamCodec() {
        return class_2338.field_48404.method_56430();
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        class_1799 currentStack;
        super.method_66473(pos, state);
        if (this.field_11863 != null && !(currentStack = this.getCurrentStack()).method_7960()) {
            class_1542 entityItem = new class_1542(this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), currentStack);
            double motion = 0.05;
            entityItem.method_18800(this.field_11863.field_9229.method_43059() * motion, 0.2, this.field_11863.field_9229.method_43059() * motion);
            this.field_11863.method_8649((class_1297)entityItem);
        }
    }
}

