/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.DelegateContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.DefaultEnergyStorage;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.excompressum.block.entity.AbstractBaseBlockEntity;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.component.ModComponents;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.menu.AutoCompressorMenu;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipe;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9473;

public class AutoCompressorBlockEntity
extends AbstractBaseBlockEntity
implements BalmMenuProvider<class_2338>,
BalmEnergyStorageProvider,
BalmContainerProvider {
    private final DefaultEnergyStorage energyStorage = new DefaultEnergyStorage(this, 32000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                this.setChanged();
            }
            return super.fill(maxReceive, simulate);
        }
    };
    private final Multiset<CompressedRecipe> inputItems = HashMultiset.create();
    private final DefaultContainer backingContainer = new DefaultContainer(24);
    private final SubContainer inputSlots = new SubContainer((class_1263)this.backingContainer, 0, 12);
    private final SubContainer outputSlots = new SubContainer((class_1263)this.backingContainer, 12, 24);
    private final class_1263 container = new DelegateContainer((class_1263)this.backingContainer){

        public boolean method_5437(int slot, class_1799 itemStack) {
            return AutoCompressorBlockEntity.this.inputSlots.containsOuterSlot(slot) && ExRegistries.getCompressedRecipeRegistry().getRecipe(itemStack) != null;
        }

        public int[] method_5494(class_2350 direction) {
            if (direction == class_2350.field_11033) {
                return AutoCompressorBlockEntity.this.outputSlots.getOuterSlotsForFace(direction);
            }
            return AutoCompressorBlockEntity.this.inputSlots.getOuterSlotsForFace(direction);
        }

        public boolean method_5493(int slot, class_1799 itemStack, class_2350 direction) {
            return AutoCompressorBlockEntity.this.outputSlots.containsOuterSlot(slot);
        }
    };
    private final List<class_1799> overflowBuffer = new ArrayList<class_1799>();
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int id) {
            if (id == 0) {
                return (int)(100.0f * AutoCompressorBlockEntity.this.getProgress());
            }
            if (id == 1) {
                return AutoCompressorBlockEntity.this.getEnergyStorage().getEnergy();
            }
            if (id == 2) {
                return AutoCompressorBlockEntity.this.isDisabledByRedstone() ? 1 : 0;
            }
            return 0;
        }

        public void method_17391(int id, int value) {
            if (id == 0) {
                AutoCompressorBlockEntity.this.setProgress((float)value / 100.0f);
            } else if (id == 1) {
                AutoCompressorBlockEntity.this.getEnergyStorage().setEnergy(value);
            } else if (id == 2) {
                AutoCompressorBlockEntity.this.setDisabledByRedstone(value == 1);
            }
        }

        public int method_17389() {
            return 3;
        }
    };
    private class_2371<class_1799> currentBuffer = class_2371.method_10211();
    private CompressedRecipe currentRecipe = null;
    private float progress;
    private boolean isDisabledByRedstone;

    public AutoCompressorBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.autoCompressor.get(), pos, state);
    }

    public AutoCompressorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public boolean shouldCompress(Multiset<CompressedRecipe> inputItems, CompressedRecipe compressedRecipe) {
        return inputItems.count((Object)compressedRecipe) >= compressedRecipe.count();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, AutoCompressorBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void serverTick() {
        int effectiveEnergy = this.getEffectiveEnergy();
        if (!this.isDisabledByRedstone() && this.overflowBuffer.isEmpty() && this.energyStorage.getEnergy() > effectiveEnergy) {
            if (this.currentRecipe == null) {
                this.inputItems.clear();
                for (int i = 0; i < this.inputSlots.method_5439(); ++i) {
                    CompressedRecipe compressedRecipe;
                    class_1799 slotStack = this.inputSlots.method_5438(i);
                    if (slotStack.method_7960() || (compressedRecipe = ExRegistries.getCompressedRecipeRegistry().getRecipe(slotStack)) == null) continue;
                    this.inputItems.add((Object)compressedRecipe, slotStack.method_7947());
                }
                for (CompressedRecipe compressedRecipe : this.inputItems.elementSet()) {
                    class_1856 ingredient = compressedRecipe.ingredient();
                    if (!this.shouldCompress(this.inputItems, compressedRecipe)) continue;
                    int space = 0;
                    for (int i = 0; i < this.outputSlots.method_5439(); ++i) {
                        class_1799 slotStack = this.outputSlots.method_5438(i);
                        if (slotStack.method_7960()) {
                            space = 64;
                        } else if (this.isItemEqualWildcard(slotStack, compressedRecipe.resultStack())) {
                            space += slotStack.method_7914() - slotStack.method_7947();
                        }
                        if (space >= compressedRecipe.resultStack().method_7947()) break;
                    }
                    if (space < compressedRecipe.resultStack().method_7947()) continue;
                    int count = compressedRecipe.count();
                    for (int i = 0; i < this.inputSlots.method_5439(); ++i) {
                        class_1799 slotStack = this.inputSlots.method_5438(i);
                        if (slotStack.method_7960() || !ingredient.method_8093(slotStack)) continue;
                        if (slotStack.method_7947() >= count) {
                            this.currentBuffer.add((Object)slotStack.method_7971(count));
                            if (slotStack.method_7960()) {
                                this.inputSlots.method_5447(i, class_1799.field_8037);
                            }
                            count = 0;
                            break;
                        }
                        this.currentBuffer.add((Object)slotStack.method_7972());
                        count -= slotStack.method_7947();
                        this.inputSlots.method_5447(i, class_1799.field_8037);
                    }
                    if (count <= 0) {
                        this.currentRecipe = compressedRecipe;
                        this.progress = 0.0f;
                    }
                    break;
                }
            } else {
                this.energyStorage.drain(effectiveEnergy, false);
                this.progress = Math.min(1.0f, this.progress + this.getEffectiveSpeed());
                if (this.progress >= 1.0f) {
                    class_1799 resultStack;
                    CompressedRecipe compressedRecipe;
                    if (!this.field_11863.method_8608() && (compressedRecipe = this.currentRecipe) != null && !this.addItemToOutput(resultStack = compressedRecipe.resultStack().method_7972())) {
                        this.overflowBuffer.add(resultStack);
                    }
                    this.currentBuffer.clear();
                    this.currentRecipe = null;
                    this.progress = 0.0f;
                }
            }
        } else if (!this.overflowBuffer.isEmpty() && this.addItemToOutput(this.overflowBuffer.get(0))) {
            this.overflowBuffer.remove(0);
        }
    }

    private boolean isItemEqualWildcard(class_1799 itemStack, class_1799 otherStack) {
        return class_1799.method_31577((class_1799)itemStack, (class_1799)otherStack) && (class_1799.method_7984((class_1799)itemStack, (class_1799)otherStack) || itemStack.method_7909() == otherStack.method_7909());
    }

    private boolean addItemToOutput(class_1799 itemStack) {
        int firstEmptySlot = -1;
        for (int i = 0; i < this.outputSlots.method_5439(); ++i) {
            class_1799 slotStack = this.outputSlots.method_5438(i);
            if (slotStack.method_7960()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (slotStack.method_7947() + itemStack.method_7947() > slotStack.method_7914() || !this.isItemEqualWildcard(slotStack, itemStack)) continue;
            slotStack.method_7933(itemStack.method_7947());
            return true;
        }
        if (firstEmptySlot != -1) {
            this.outputSlots.method_5447(firstEmptySlot, itemStack);
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ExCompressumConfig.getActive().automation.autoCompressorEnergy;
    }

    public float getEffectiveSpeed() {
        return (float)ExCompressumConfig.getActive().automation.autoCompressorSpeed;
    }

    public void method_11014(class_11368 input) {
        this.currentRecipe = input.method_71441("CurrentRecipe").map(class_2960::method_60654).map(ExRegistries.getCompressedRecipeRegistry()::getRecipeById).orElse(this.currentRecipe);
        this.isDisabledByRedstone = input.method_71433("IsDisabledByRedstone", false);
        this.progress = input.method_71423("Progress", 0.0f);
        input.method_71420("ItemHandler").ifPresent(it -> class_1262.method_5429((class_11368)it, (class_2371)this.backingContainer.getItems()));
        input.method_71420("EnergyStorage").ifPresent(it -> this.energyStorage.deserialize(it));
        this.overflowBuffer.clear();
        input.method_71435("OverflowBuffer", class_1799.field_24671).ifPresent(overflowItems -> {
            for (class_1799 overflowItem : overflowItems) {
                this.overflowBuffer.add(overflowItem);
            }
        });
    }

    public void method_11007(class_11372 output) {
        if (this.currentRecipe != null) {
            output.method_71469("CurrentRecipe", this.currentRecipe.id().toString());
        }
        output.method_71472("IsDisabledByRedstone", this.isDisabledByRedstone);
        output.method_71464("Progress", this.progress);
        class_1262.method_5426((class_11372)output.method_71461("ItemHandler"), (class_2371)this.backingContainer.getItems());
        this.energyStorage.serialize(output.method_71461("EnergyStorage"));
        class_11372.class_11373 overflowList = output.method_71467("OverflowBuffer", class_1799.field_24671);
        for (class_1799 itemStack : this.overflowBuffer) {
            overflowList.method_71484((Object)itemStack);
        }
    }

    public void writeUpdateTag(class_11372 output) {
        this.method_11007(output);
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public float getEnergyPercentage() {
        return (float)this.energyStorage.getEnergy() / (float)this.energyStorage.getCapacity();
    }

    public class_2371<class_1799> getCurrentBuffer() {
        return this.currentBuffer;
    }

    public class_1263 getBackingContainer() {
        return this.backingContainer;
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public class_1263 getContainer(class_2350 side) {
        if (side == class_2350.field_11033) {
            return this.outputSlots;
        }
        return super.getContainer(side);
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public boolean isDisabledByRedstone() {
        return this.isDisabledByRedstone;
    }

    public void setDisabledByRedstone(boolean disabledByRedstone) {
        this.isDisabledByRedstone = disabledByRedstone;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.excompressum.auto_compressor");
    }

    public class_1703 createMenu(int windowId, class_1661 inv, class_1657 player) {
        return new AutoCompressorMenu(windowId, inv, this);
    }

    public class_3913 getContainerData() {
        return this.containerData;
    }

    protected void method_57567(class_9323.class_9324 builder) {
        builder.method_57840((class_9331)ModComponents.energy.get(), (Object)this.energyStorage.getEnergy());
    }

    protected void method_57568(class_9473 input) {
        Integer energyComponent = (Integer)input.method_58694((class_9331)ModComponents.energy.get());
        if (energyComponent != null) {
            this.energyStorage.setEnergy(energyComponent.intValue());
        }
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayer) {
        return this.field_11867;
    }

    public class_9139<class_9129, class_2338> getScreenStreamCodec() {
        return class_2338.field_48404.method_56430();
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        super.method_66473(pos, state);
        if (this.field_11863 != null) {
            for (class_1799 currentStack : this.getCurrentBuffer()) {
                if (currentStack.method_7960()) continue;
                this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), currentStack));
            }
        }
    }
}

