/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.DelegateContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.DefaultEnergyStorage;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.block.AutoHammerBlock;
import net.blay09.mods.excompressum.block.ModBlockStateProperties;
import net.blay09.mods.excompressum.block.entity.AbstractBaseBlockEntity;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.component.ModComponents;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.menu.AutoHammerMenu;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.registry.hammer.HammerRegistry;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_47;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class AutoHammerBlockEntity
extends AbstractBaseBlockEntity
implements BalmMenuProvider<class_2338>,
BalmContainerProvider,
BalmEnergyStorageProvider {
    private static final int UPDATE_INTERVAL = 20;
    private final DefaultEnergyStorage energyStorage = new DefaultEnergyStorage(32000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                AutoHammerBlockEntity.this.isDirty = true;
            }
            return super.fill(maxReceive, simulate);
        }
    };
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int id) {
            if (id == 0) {
                return (int)(100.0f * AutoHammerBlockEntity.this.getProgress());
            }
            if (id == 1) {
                return AutoHammerBlockEntity.this.getEnergyStorage().getEnergy();
            }
            if (id == 2) {
                return AutoHammerBlockEntity.this.isDisabledByRedstone() ? 1 : 0;
            }
            return 0;
        }

        public void method_17391(int id, int value) {
            if (id == 0) {
                AutoHammerBlockEntity.this.setProgress((float)value / 100.0f);
            } else if (id == 1) {
                AutoHammerBlockEntity.this.getEnergyStorage().setEnergy(value);
            } else if (id == 2) {
                AutoHammerBlockEntity.this.setDisabledByRedstone(value == 1);
            }
        }

        public int method_17389() {
            return 3;
        }
    };
    private final DefaultContainer backingContainer = new DefaultContainer(23){

        public boolean method_5437(int slot, class_1799 itemStack) {
            if (AutoHammerBlockEntity.this.inputSlots.containsOuterSlot(slot)) {
                class_3218 serverLevel;
                class_1937 class_19372 = AutoHammerBlockEntity.this.field_11863;
                return class_19372 instanceof class_3218 && AutoHammerBlockEntity.this.isRegistered(serverLevel = (class_3218)class_19372, itemStack);
            }
            if (AutoHammerBlockEntity.this.hammerSlots.containsOuterSlot(slot)) {
                return AutoHammerBlockEntity.this.isHammerUpgrade(itemStack);
            }
            return true;
        }

        public void slotChanged(int slot) {
            super.slotChanged(slot);
            if (AutoHammerBlockEntity.this.hammerSlots.containsOuterSlot(slot)) {
                AutoHammerBlockEntity.this.isDirty = true;
            }
        }
    };
    private final SubContainer inputSlots = new SubContainer((class_1263)this.backingContainer, 0, 1);
    private final SubContainer outputSlots = new SubContainer((class_1263)this.backingContainer, 1, 21);
    private final SubContainer hammerSlots = new SubContainer((class_1263)this.backingContainer, 21, 23);
    private final List<class_1799> overflowBuffer = new ArrayList<class_1799>();
    private final DelegateContainer container = new DelegateContainer((class_1263)this.backingContainer){

        public boolean method_5437(int slot, class_1799 itemStack) {
            return super.method_5437(slot, itemStack) && (AutoHammerBlockEntity.this.inputSlots.containsOuterSlot(slot) || AutoHammerBlockEntity.this.hammerSlots.containsOuterSlot(slot));
        }

        public int[] method_5494(class_2350 direction) {
            if (direction == class_2350.field_11033) {
                return AutoHammerBlockEntity.this.outputSlots.getOuterSlotsForFace(direction);
            }
            if (direction == class_2350.field_11036) {
                return AutoHammerBlockEntity.this.inputSlots.getOuterSlotsForFace(direction);
            }
            return AutoHammerBlockEntity.this.hammerSlots.getOuterSlotsForFace(direction);
        }

        public boolean method_5493(int slot, class_1799 itemStack, class_2350 direction) {
            return AutoHammerBlockEntity.this.outputSlots.containsOuterSlot(slot);
        }
    };
    private class_1799 currentStack = class_1799.field_8037;
    private int cooldown;
    private int ticksSinceUpdate;
    private boolean isDirty;
    private float progress;
    private class_1799 finishedStack = class_1799.field_8037;
    public float hammerAngle;
    private boolean isDisabledByRedstone;

    public AutoHammerBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.autoHammer.get(), pos, state);
    }

    public AutoHammerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, AutoHammerBlockEntity blockEntity) {
        blockEntity.clientTick();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, AutoHammerBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void clientTick() {
        if (!this.finishedStack.method_7960()) {
            class_2680 state = StupidUtils.getStateFromItemStack(this.finishedStack);
            if (!state.method_26215()) {
                ExCompressum.proxy.get().spawnCrushParticles(this.field_11863, this.field_11867, state);
            }
            this.finishedStack = class_1799.field_8037;
        }
    }

    public void serverTick() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        int effectiveEnergy = this.getEffectiveEnergy();
        if (!this.isDisabledByRedstone() && this.overflowBuffer.isEmpty() && this.getEnergyStored() >= effectiveEnergy) {
            if (this.currentStack.method_7960() && this.cooldown <= 0) {
                class_1799 inputStack = this.inputSlots.method_5438(0);
                if (!inputStack.method_7960() && this.isRegistered((class_3218)this.field_11863, inputStack)) {
                    boolean foundSpace = false;
                    for (int i = 0; i < this.outputSlots.method_5439(); ++i) {
                        if (!this.outputSlots.method_5438(i).method_7960()) continue;
                        foundSpace = true;
                    }
                    if (!foundSpace) {
                        return;
                    }
                    this.currentStack = inputStack.method_7971(1);
                    if (inputStack.method_7960()) {
                        this.inputSlots.method_5447(0, class_1799.field_8037);
                    }
                    this.energyStorage.drain(effectiveEnergy, false);
                    this.ticksSinceUpdate = 20;
                    this.progress = 0.0f;
                }
            } else {
                this.energyStorage.drain(effectiveEnergy, false);
                this.progress += this.getEffectiveSpeed();
                this.isDirty = true;
                if (this.progress >= 1.0f) {
                    if (!this.field_11863.method_8608()) {
                        if ((double)this.field_11863.field_9229.method_43057() <= ExCompressumConfig.getActive().automation.autoHammerDecay) {
                            class_1799 secondHammer;
                            class_1799 firstHammer = this.hammerSlots.method_5438(0);
                            if (!firstHammer.method_7960()) {
                                firstHammer.method_7956(1, (class_3218)this.field_11863, null, it -> this.hammerSlots.method_5447(0, class_1799.field_8037));
                            }
                            if (!(secondHammer = this.hammerSlots.method_5438(1)).method_7960()) {
                                secondHammer.method_7956(1, (class_3218)this.field_11863, null, it -> this.hammerSlots.method_5447(1, class_1799.field_8037));
                            }
                        }
                        Collection<class_1799> rewards = this.rollHammerRewards((class_3218)this.field_11863, this.currentStack, this.getEffectiveTool(), this.field_11863.field_9229);
                        for (class_1799 itemStack : rewards) {
                            if (this.addItemToOutput(itemStack)) continue;
                            this.overflowBuffer.add(itemStack);
                        }
                    }
                    this.finishedStack = this.currentStack;
                    this.progress = 0.0f;
                    this.ticksSinceUpdate = 20;
                    this.cooldown = 2;
                    this.currentStack = class_1799.field_8037;
                }
            }
        } else if (!this.overflowBuffer.isEmpty() && this.addItemToOutput(this.overflowBuffer.getFirst())) {
            this.overflowBuffer.removeFirst();
        }
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate > 20) {
            if (this.isDirty) {
                this.sync();
                this.finishedStack = class_1799.field_8037;
                this.isDirty = false;
            }
            this.ticksSinceUpdate = 0;
        }
    }

    private class_1799 getEffectiveTool() {
        return Math.random() < 0.5 ? this.hammerSlots.method_5438(0) : this.hammerSlots.method_5438(1);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergy();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getCapacity();
    }

    private boolean addItemToOutput(class_1799 itemStack) {
        int firstEmptySlot = -1;
        for (int i = 0; i < this.outputSlots.method_5439(); ++i) {
            class_1799 slotStack = this.outputSlots.method_5438(i);
            if (slotStack.method_7960()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (slotStack.method_7947() + itemStack.method_7947() > slotStack.method_7914() || !class_1799.method_31577((class_1799)slotStack, (class_1799)itemStack)) continue;
            slotStack.method_7933(itemStack.method_7947());
            return true;
        }
        if (firstEmptySlot != -1) {
            this.outputSlots.method_5447(firstEmptySlot, itemStack);
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ExCompressumConfig.getActive().automation.autoHammerEnergy;
    }

    public float getSpeedMultiplier() {
        class_1799 secondHammer;
        float HAMMER_BOOST = 0.5f;
        float EFFICIENCY_BOOST = 0.5f;
        float boost = 1.0f;
        class_6880.class_6883 efficiencyEnchantment = this.field_11863.method_30349().method_30530(class_7924.field_41265).method_46747(class_1893.field_9131);
        class_1799 firstHammer = this.hammerSlots.method_5438(0);
        if (!firstHammer.method_7960() && this.isHammerUpgrade(firstHammer)) {
            boost += 0.5f;
            boost += 0.5f * (float)class_1890.method_8225((class_6880)efficiencyEnchantment, (class_1799)firstHammer);
        }
        if (!(secondHammer = this.hammerSlots.method_5438(1)).method_7960() && this.isHammerUpgrade(secondHammer)) {
            boost += 0.5f;
            boost += 0.5f * (float)class_1890.method_8225((class_6880)efficiencyEnchantment, (class_1799)secondHammer);
        }
        return boost;
    }

    public float getEffectiveSpeed() {
        return (float)(ExCompressumConfig.getActive().automation.autoHammerSpeed * (double)this.getSpeedMultiplier());
    }

    public float getEffectiveLuck() {
        class_1799 secondHammer;
        float luck = 0.0f;
        class_6880.class_6883 fortuneEnchantment = this.field_11863.method_30349().method_30530(class_7924.field_41265).method_46747(class_1893.field_9130);
        class_1799 firstHammer = this.hammerSlots.method_5438(0);
        if (!firstHammer.method_7960() && this.isHammerUpgrade(firstHammer)) {
            luck += (float)class_1890.method_8225((class_6880)fortuneEnchantment, (class_1799)firstHammer);
        }
        if (!(secondHammer = this.hammerSlots.method_5438(1)).method_7960() && this.isHammerUpgrade(secondHammer)) {
            luck += (float)class_1890.method_8225((class_6880)fortuneEnchantment, (class_1799)secondHammer);
        }
        return luck;
    }

    public void method_11014(class_11368 input) {
        this.currentStack = input.method_71426("CurrentStack", class_1799.field_49266).orElse(this.currentStack);
        this.progress = input.method_71423("Progress", 0.0f);
        input.method_71420("EnergyStorage").ifPresent(it -> this.energyStorage.deserialize(it));
        input.method_71420("ItemHandler").ifPresent(it -> class_1262.method_5429((class_11368)it, (class_2371)this.backingContainer.getItems()));
        this.isDisabledByRedstone = input.method_71433("IsDisabledByRedstone", false);
        this.finishedStack = input.method_71426("FinishedStack", class_1799.field_49266).orElse(this.finishedStack);
        input.method_71426("FirstHammer", class_1799.field_49266).ifPresent(hammer -> this.hammerSlots.method_5447(0, hammer));
        input.method_71426("SecondHammer", class_1799.field_49266).ifPresent(hammer -> this.hammerSlots.method_5447(1, hammer));
        this.overflowBuffer.clear();
        input.method_71435("OverflowBuffer", class_1799.field_24671).ifPresent(overflowItems -> {
            for (class_1799 overflowItem : overflowItems) {
                this.overflowBuffer.add(overflowItem);
            }
        });
    }

    public void method_11007(class_11372 output) {
        this.energyStorage.serialize(output.method_71461("EnergyStorage"));
        output.method_71468("CurrentStack", class_1799.field_49266, (Object)this.currentStack);
        output.method_71468("FinishedStack", class_1799.field_49266, (Object)this.finishedStack);
        output.method_71464("Progress", this.progress);
        class_1262.method_5426((class_11372)output.method_71461("ItemHandler"), (class_2371)this.backingContainer.getItems());
        output.method_71472("IsDisabledByRedstone", this.isDisabledByRedstone);
        class_11372.class_11373 overflowList = output.method_71467("OverflowBuffer", class_1799.field_24671);
        for (class_1799 itemStack : this.overflowBuffer) {
            overflowList.method_71484((Object)itemStack);
        }
    }

    public void writeUpdateTag(class_11372 output) {
        this.method_11007(output);
        output.method_71468("FirstHammer", class_1799.field_49266, (Object)this.hammerSlots.method_5438(0));
        output.method_71468("SecondHammer", class_1799.field_49266, (Object)this.hammerSlots.method_5438(1));
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public float getEnergyPercentage() {
        return (float)this.getEnergyStored() / (float)this.getMaxEnergyStored();
    }

    public class_1799 getCurrentStack() {
        return this.currentStack;
    }

    @Nullable
    public class_2680 getCurrentBlock() {
        return StupidUtils.getStateFromItemStack(this.currentStack);
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public DefaultContainer getBackingContainer() {
        return this.backingContainer;
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public class_1799 getUpgradeStack(int i) {
        return this.hammerSlots.method_5438(i);
    }

    public boolean isHammerUpgrade(class_1799 itemStack) {
        return itemStack.method_31573(ModItemTags.HAMMERS);
    }

    public boolean isRegistered(class_3218 level, class_1799 itemStack) {
        if (level == null) {
            return false;
        }
        class_1863 recipeManager = level.method_8503().method_3772();
        return ExNihilo.isHammerable((class_1937)level, itemStack) || ExRegistries.getHammerRegistry().isHammerable(recipeManager, itemStack);
    }

    public Collection<class_1799> rollHammerRewards(class_3218 level, class_1799 itemStack, class_1799 toolItem, class_5819 rand) {
        if (level == null) {
            return Collections.emptyList();
        }
        class_1863 recipeManager = level.method_8503().method_3772();
        if (ExRegistries.getHammerRegistry().isHammerable(recipeManager, itemStack)) {
            class_47 lootContext = LootTableUtils.buildLootContext(level, itemStack);
            return HammerRegistry.rollHammerRewards(lootContext, itemStack);
        }
        class_2680 currentState = StupidUtils.getStateFromItemStack(itemStack);
        return ExNihilo.getInstance().rollHammerRewards((class_1937)level, currentState, toolItem, rand);
    }

    public boolean shouldAnimate() {
        return !this.currentStack.method_7960() && this.getEnergyStored() >= this.getEffectiveEnergy() && !this.isDisabledByRedstone();
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public boolean isUgly() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)ModBlockStateProperties.UGLY)) {
            return (Boolean)state.method_11654((class_2769)ModBlockStateProperties.UGLY);
        }
        return false;
    }

    public class_2350 getFacing() {
        class_2680 state = this.method_11010();
        if (state.method_28498(AutoHammerBlock.FACING)) {
            return (class_2350)state.method_11654(AutoHammerBlock.FACING);
        }
        return class_2350.field_11043;
    }

    public boolean isDisabledByRedstone() {
        return this.isDisabledByRedstone;
    }

    public void setDisabledByRedstone(boolean disabledByRedstone) {
        this.isDisabledByRedstone = disabledByRedstone;
        this.isDirty = true;
        this.ticksSinceUpdate = 20;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.excompressum.auto_hammer");
    }

    public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
        return new AutoHammerMenu(windowId, inventory, this);
    }

    public class_3913 getContainerData() {
        return this.containerData;
    }

    protected void method_57567(class_9323.class_9324 builder) {
        builder.method_57840((class_9331)ModComponents.energy.get(), (Object)this.energyStorage.getEnergy());
    }

    protected void method_57568(class_9473 input) {
        Integer energyComponent = (Integer)input.method_58694((class_9331)ModComponents.energy.get());
        if (energyComponent != null) {
            this.energyStorage.setEnergy(energyComponent.intValue());
        }
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayer) {
        return this.field_11867;
    }

    public class_9139<class_9129, class_2338> getScreenStreamCodec() {
        return class_2338.field_48404.method_56430();
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        class_1799 currentStack;
        super.method_66473(pos, state);
        if (this.field_11863 != null && !(currentStack = this.getCurrentStack()).method_7960()) {
            this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), currentStack));
        }
    }
}

