/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import java.util.Collection;
import java.util.stream.Collectors;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.excompressum.block.BaitBlock;
import net.blay09.mods.excompressum.block.BaitType;
import net.blay09.mods.excompressum.block.entity.BaitEnvironmentCondition;
import net.blay09.mods.excompressum.block.entity.EnvironmentalConditionResult;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.mixin.LlamaAccessor;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1481;
import net.minecraft.class_1501;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;

public class BaitBlockEntity
extends BalmBlockEntity {
    private static final int ENVIRONMENTAL_CHECK_INTERVAL = 200;
    private static final int MAX_BAITS_IN_AREA = 2;
    private static final int MIN_ENV_IN_AREA = 10;
    private static final int MAX_ANIMALS_IN_AREA = 2;
    private static final int SPAWN_CHECK_INTERVAL = 20;
    private static final int MIN_DISTANCE_NO_PLAYERS = 6;
    private EnvironmentalConditionResult environmentStatus;
    private int ticksSinceEnvironmentalCheck;
    private int ticksSinceSpawnCheck;

    public BaitBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.bait.get(), pos, state);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, BaitBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void serverTick() {
        BaitType baitType = this.getBaitType();
        ++this.ticksSinceEnvironmentalCheck;
        ++this.ticksSinceSpawnCheck;
        if (this.ticksSinceSpawnCheck >= 20) {
            if (!this.field_11863.method_8608() && this.field_11863.field_9229.method_43057() <= baitType.getChance() && this.checkSpawnConditions(true) == EnvironmentalConditionResult.CanSpawn) {
                float range = 6.0f;
                if (this.field_11863.method_18467(class_1657.class, new class_238((double)((float)this.field_11867.method_10263() - 6.0f), (double)((float)this.field_11867.method_10264() - 6.0f), (double)((float)this.field_11867.method_10260() - 6.0f), (double)((float)this.field_11867.method_10263() + 6.0f), (double)((float)this.field_11867.method_10264() + 6.0f), (double)((float)this.field_11867.method_10260() + 6.0f))).isEmpty()) {
                    class_1297 entity = baitType.createEntity(this.field_11863);
                    if (entity instanceof class_1296) {
                        class_1296 mob = (class_1296)entity;
                        if ((double)this.field_11863.field_9229.method_43057() <= ExCompressumConfig.getActive().baits.childBaitChance) {
                            mob.method_5614(-24000);
                        }
                    }
                    if (entity instanceof class_1481) {
                        class_1481 turtle = (class_1481)entity;
                        turtle.method_6683(this.field_11867);
                    }
                    if (entity instanceof class_1501) {
                        class_1501 llama = (class_1501)entity;
                        class_1501.class_7993[] candidates = class_1501.class_7993.values();
                        ((LlamaAccessor)llama).callSetVariant(candidates[this.field_11863.field_9229.method_43048(candidates.length)]);
                    }
                    entity.method_5814((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5);
                    this.field_11863.method_8649(entity);
                    ((class_3218)this.field_11863).method_65096((class_2394)class_2398.field_11236, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    this.field_11863.method_8396(null, this.field_11867, class_3417.field_15219, class_3419.field_15245, 1.0f, 1.0f);
                    this.field_11863.method_8650(this.field_11867, false);
                }
            }
            this.ticksSinceSpawnCheck = 0;
        }
    }

    public EnvironmentalConditionResult checkSpawnConditions(boolean checkNow) {
        if (checkNow || this.ticksSinceEnvironmentalCheck > 200) {
            BaitType baitType = this.getBaitType();
            Collection<BaitEnvironmentCondition> envBlocks = baitType.getEnvironmentConditions();
            int range = 5;
            int rangeVertical = 3;
            int countBait = 0;
            int countEnvBlocks = 0;
            boolean foundWater = false;
            for (int x = this.field_11867.method_10263() - 5; x < this.field_11867.method_10263() + 5; ++x) {
                for (int y = this.field_11867.method_10264() - 3; y < this.field_11867.method_10264() + 3; ++y) {
                    for (int z = this.field_11867.method_10260() - 5; z < this.field_11867.method_10260() + 5; ++z) {
                        class_2338 testPos = new class_2338(x, y, z);
                        class_2680 blockState = this.field_11863.method_8320(testPos);
                        class_3610 fluidState = this.field_11863.method_8316(testPos);
                        if (blockState.method_26204() instanceof BaitBlock) {
                            ++countBait;
                        } else if (fluidState.method_15772() == class_3612.field_15910 || fluidState.method_15772() == class_3612.field_15909) {
                            foundWater = true;
                        }
                        for (BaitEnvironmentCondition envBlock : envBlocks) {
                            if (!envBlock.test(blockState, fluidState)) continue;
                            ++countEnvBlocks;
                        }
                    }
                }
            }
            if (!foundWater) {
                this.environmentStatus = EnvironmentalConditionResult.NoWater;
            } else if (countBait > 2) {
                this.environmentStatus = EnvironmentalConditionResult.NearbyBait;
            } else if (countEnvBlocks < 10) {
                String listOfBlocks = envBlocks.stream().map(BaitEnvironmentCondition::getDisplayName).map(class_2561::getString).collect(Collectors.joining(", "));
                this.environmentStatus = EnvironmentalConditionResult.wrongEnv(listOfBlocks);
            } else {
                this.environmentStatus = this.field_11863.method_18467(class_1429.class, new class_238((double)(this.field_11867.method_10263() - 10), (double)(this.field_11867.method_10264() - 3), (double)(this.field_11867.method_10260() - 10), (double)(this.field_11867.method_10263() + 10), (double)(this.field_11867.method_10264() + 3), (double)(this.field_11867.method_10260() + 10))).size() > 2 ? EnvironmentalConditionResult.NearbyAnimal : EnvironmentalConditionResult.CanSpawn;
            }
            this.ticksSinceEnvironmentalCheck = 0;
        }
        return this.environmentStatus;
    }

    public BaitType getBaitType() {
        return ((BaitBlock)this.method_11010().method_26204()).getBaitType();
    }
}

