/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import java.util.List;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_47;
import org.jetbrains.annotations.Nullable;

public class HeavySieveBlockEntity
extends BalmBlockEntity {
    private static final float PROCESSING_INTERVAL = 0.075f;
    private static final int UPDATE_INTERVAL = 5;
    private static final int PARTICLE_TICKS = 20;
    private static final float EFFICIENCY_BOOST = 0.25f;
    private class_1799 meshStack = class_1799.field_8037;
    private class_1799 currentStack = class_1799.field_8037;
    private float progress;
    private int clicksSinceSecond;
    private boolean isDirty;
    private int ticksSinceSync;
    private int ticksSinceSecond;
    private int particleTicks;
    private int particleCount;

    public HeavySieveBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.heavySieve.get(), pos, state);
    }

    public boolean addSiftable(class_3218 level, class_1657 player, class_1799 itemStack) {
        if (!this.currentStack.method_7960() || this.meshStack.method_7960() || !ExRegistries.getHeavySieveRegistry().isSiftable(level, this.method_11010(), itemStack, this.getSieveMesh())) {
            return false;
        }
        this.currentStack = player.method_31549().field_7477 ? ContainerUtils.copyStackWithSize((class_1799)itemStack, (int)1) : itemStack.method_7971(1);
        this.progress = 0.0f;
        this.sync();
        return true;
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, HeavySieveBlockEntity blockEntity) {
        blockEntity.clientTick();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, HeavySieveBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void clientTick() {
        if (this.particleTicks > 0) {
            class_2680 state;
            --this.particleTicks;
            if (this.particleTicks <= 0) {
                this.particleCount = 0;
            }
            if (!this.currentStack.method_7960() && !(state = StupidUtils.getStateFromItemStack(this.currentStack)).method_26215()) {
                ExCompressum.proxy.get().spawnHeavySieveParticles(this.field_11863, this.field_11867, state, this.particleCount);
            }
        }
    }

    public void serverTick() {
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 5) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                this.sync();
                this.isDirty = false;
            }
        }
        ++this.ticksSinceSecond;
        if (this.ticksSinceSecond >= 20) {
            this.clicksSinceSecond = 0;
            this.ticksSinceSecond = 0;
        }
    }

    public boolean processContents(class_1657 player) {
        if (this.currentStack.method_7960() || this.meshStack.method_7960()) {
            return false;
        }
        if (player.method_31549().field_7477) {
            this.progress = 1.0f;
        } else {
            ++this.clicksSinceSecond;
            if (this.clicksSinceSecond <= ExCompressumConfig.getActive().automation.heavySieveClicksPerSecond) {
                int efficiency = ExNihilo.getInstance().getMeshEfficiency(this.meshStack);
                this.progress = Math.min(1.0f, this.progress + 0.075f * (1.0f + (float)efficiency * 0.25f));
            }
        }
        if (this.progress >= 1.0f) {
            this.particleCount = 0;
            if (!this.field_11863.method_8608()) {
                SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
                if (sieveMesh != null) {
                    class_47 lootContext = LootTableUtils.buildLootContext((class_3218)this.field_11863, this.currentStack);
                    List<class_1799> rewards = HeavySieveRegistry.rollSieveRewards(this.field_11863, lootContext, this.method_11010(), sieveMesh, this.currentStack);
                    for (class_1799 itemStack : rewards) {
                        this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, itemStack));
                    }
                } else {
                    this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, this.currentStack));
                }
                this.currentStack = class_1799.field_8037;
                if (ExNihilo.getInstance().doMeshesHaveDurability() && sieveMesh != null) {
                    if (!sieveMesh.isHeavy()) {
                        this.field_11863.method_8396(null, this.field_11867, (class_3414)class_3417.field_15075.comp_349(), class_3419.field_15245, 0.5f, 2.5f);
                        this.meshStack = class_1799.field_8037;
                    } else {
                        this.meshStack.method_7956(1, (class_3218)this.field_11863, (class_3222)player, it -> {
                            this.field_11863.method_8396(null, this.field_11867, (class_3414)class_3417.field_15075.comp_349(), class_3419.field_15245, 0.5f, 2.5f);
                            this.meshStack = class_1799.field_8037;
                        });
                    }
                }
                this.progress = 0.0f;
                this.sync();
            }
        }
        this.method_5431();
        this.particleTicks = 20;
        ++this.particleCount;
        this.isDirty = true;
        return true;
    }

    public void method_11014(class_11368 input) {
        this.currentStack = input.method_71426("Content", class_1799.field_49266).orElse(class_1799.field_8037);
        this.meshStack = input.method_71426("Mesh", class_1799.field_49266).orElse(class_1799.field_8037);
        this.progress = input.method_71423("Progress", 0.0f);
        this.particleTicks = input.method_71424("ParticleTicks", 0);
        this.particleCount = input.method_71424("ParticleCount", 0);
    }

    public void method_11007(class_11372 output) {
        output.method_71468("Content", class_1799.field_49266, (Object)this.currentStack);
        output.method_71468("Mesh", class_1799.field_49266, (Object)this.meshStack);
        output.method_71464("Progress", this.progress);
        output.method_71465("ParticleTicks", this.particleTicks);
        output.method_71465("ParticleCount", this.particleCount);
    }

    public void writeUpdateTag(class_11372 output) {
        this.method_11007(output);
    }

    public class_1799 getCurrentStack() {
        return this.currentStack;
    }

    public class_1799 getMeshStack() {
        return this.meshStack;
    }

    public float getProgress() {
        return this.progress;
    }

    @Nullable
    public SieveMeshRegistryEntry getSieveMesh() {
        if (!this.meshStack.method_7960()) {
            return SieveMeshRegistry.getEntry(this.meshStack);
        }
        return null;
    }

    public void setMeshStack(class_1799 meshStack) {
        this.meshStack = meshStack;
        this.method_5431();
        this.sync();
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        super.method_66473(pos, state);
        if (this.field_11863 != null && !this.getMeshStack().method_7960()) {
            this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, this.getMeshStack()));
        }
    }
}

