/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import java.util.Objects;
import net.blay09.mods.balm.api.container.ImplementedContainer;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.DefaultFluidTank;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.registry.woodencrucible.WoodenCrucibleRecipe;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class WoodenCrucibleBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider,
ImplementedContainer {
    private static final int RAIN_FILL_INTERVAL = 20;
    private static final int MELT_INTERVAL = 20;
    private static final int RAIN_FILL_SPEED = 8;
    private static final int SYNC_INTERVAL = 10;
    private final class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private final DefaultFluidTank fluidTank = new DefaultFluidTank(1999){

        public int fill(class_3611 fluid, int maxFill, boolean simulate) {
            int result = super.fill(fluid, maxFill, simulate);
            if (this.getAmount() > 1000) {
                this.setAmount(1000);
            }
            return result;
        }

        public boolean canFill(class_3611 fluid) {
            return ((class_1799)WoodenCrucibleBlockEntity.this.items.get(0)).method_7960() && WoodenCrucibleBlockEntity.this.isValidFluid(fluid);
        }

        public int getCapacity() {
            return 1000;
        }

        public void setChanged() {
            WoodenCrucibleBlockEntity.this.method_5431();
            WoodenCrucibleBlockEntity.this.isDirty = true;
        }
    };
    private int ticksSinceSync;
    private boolean isDirty;
    private int ticksSinceRain;
    private int ticksSinceMelt;
    private class_3611 currentTargetFluid;
    private int solidVolume;

    private boolean isValidFluid(class_3611 fluid) {
        return fluid.method_15780((class_3611)class_3612.field_15910);
    }

    public WoodenCrucibleBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.woodenCrucible.get(), pos, state);
    }

    public boolean addItem(class_3218 level, class_1799 itemStack, boolean isAutomated, boolean simulate) {
        if (this.fluidTank.getAmount() >= 1000 && itemStack.method_31573(ModItemTags.DUSTS)) {
            if (!simulate) {
                this.items.set(0, (Object)new class_1799((class_1935)class_2246.field_10460));
                this.fluidTank.setFluid(class_3612.field_15906, 0);
                this.sync();
            }
            return true;
        }
        WoodenCrucibleRecipe recipe = ExRegistries.getWoodenCrucibleRegistry().getRecipe(level, itemStack);
        if (recipe != null && (this.fluidTank.isEmpty() || recipe.matchesFluid(this.fluidTank.getFluid()))) {
            int capacityLeft = this.fluidTank.getCapacity() - this.fluidTank.getAmount() - this.solidVolume;
            if (isAutomated && capacityLeft >= recipe.getAmount() || !isAutomated && capacityLeft > 0) {
                if (!simulate) {
                    this.currentTargetFluid = recipe.getFluid();
                    this.solidVolume += Math.min(capacityLeft, recipe.getAmount());
                    this.sync();
                }
                return true;
            }
        }
        return false;
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, WoodenCrucibleBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void serverTick() {
        if (this.field_11863.method_8401().method_156() && this.field_11863.method_22348(this.field_11867) && ((class_1959)this.field_11863.method_23753(this.field_11867).comp_349()).method_48163()) {
            ++this.ticksSinceRain;
            if (this.ticksSinceRain >= 20) {
                this.fluidTank.fill((class_3611)class_3612.field_15910, 8, false);
                this.ticksSinceRain = 0;
            }
        }
        if (this.currentTargetFluid != null) {
            ++this.ticksSinceMelt;
            if (this.ticksSinceMelt >= 20 && this.fluidTank.getAmount() < this.fluidTank.getCapacity()) {
                int amount = Math.min(ExCompressumConfig.getActive().automation.woodenCrucibleSpeed, this.solidVolume);
                this.fluidTank.fill(this.currentTargetFluid, amount, false);
                this.solidVolume = Math.max(0, this.solidVolume - amount);
                this.ticksSinceMelt = 0;
                this.isDirty = true;
            }
        }
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 10) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                this.sync();
                this.isDirty = false;
            }
        }
    }

    public void method_11014(class_11368 input) {
        this.solidVolume = input.method_71424("SolidVolume", 0);
        input.method_71420("FluidTank").ifPresent(arg_0 -> ((DefaultFluidTank)this.fluidTank).deserialize(arg_0));
        class_1262.method_5429((class_11368)input, this.items);
        input.method_71441("TargetFluid").map(class_2960::method_60654).flatMap(arg_0 -> ((class_7922)class_7923.field_41173).method_17966(arg_0)).ifPresent(targetFluid -> {
            this.currentTargetFluid = targetFluid;
        });
    }

    public void method_11007(class_11372 output) {
        if (this.currentTargetFluid != null) {
            class_2960 fluidId = class_7923.field_41173.method_10221((Object)this.currentTargetFluid);
            output.method_71469("TargetFluid", Objects.toString(fluidId));
        }
        output.method_71465("SolidVolume", this.solidVolume);
        this.fluidTank.serialize(output.method_71461("FluidTank"));
        class_1262.method_5426((class_11372)output, this.items);
    }

    public void writeUpdateTag(class_11372 output) {
        this.method_11007(output);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public int getSolidVolume() {
        return this.solidVolume;
    }

    public int getSolidCapacity() {
        return this.fluidTank.getCapacity();
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }
}

