/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.blockentity;

import java.util.Iterator;
import net.blay09.mods.excompressum.block.AutoHammerBlock;
import net.blay09.mods.excompressum.block.entity.AutoHammerBlockEntity;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class AutoHammerRenderer
implements class_827<AutoHammerBlockEntity, AutoHammerRenderState> {
    private final class_10442 itemModelResolver;
    private final boolean isCompressed;
    private class_1799 hammerItemStack = class_1799.field_8037;

    public AutoHammerRenderer(class_5614.class_5615 context, boolean isCompressed) {
        this.itemModelResolver = context.comp_4536();
        this.isCompressed = isCompressed;
    }

    public void extractRenderState(AutoHammerBlockEntity blockEntity, AutoHammerRenderState renderState, float delta, class_243 vec, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, delta, vec, crumblingOverlay);
        if (blockEntity.shouldAnimate()) {
            blockEntity.hammerAngle += 0.4f * delta;
        }
        renderState.skip = blockEntity.isUgly();
        renderState.facing = (class_2350)renderState.field_62674.method_11654(AutoHammerBlock.FACING);
        renderState.progress = blockEntity.getProgress();
        renderState.hammerAngle = blockEntity.hammerAngle;
        if (this.hammerItemStack.method_7960()) {
            if (this.isCompressed) {
                this.hammerItemStack = new class_1799((class_1935)ModItems.compressedDiamondHammer);
            } else {
                Iterator iterator = class_7923.field_41178.method_40286(ModItemTags.DIAMOND_HAMMERS).iterator();
                if (iterator.hasNext()) {
                    class_6880 itemHolder = (class_6880)iterator.next();
                    this.hammerItemStack = new class_1799((class_1935)itemHolder.comp_349());
                }
                if (this.hammerItemStack.method_7960()) {
                    this.hammerItemStack = new class_1799((class_1935)class_1802.field_8377);
                }
            }
        }
        this.itemModelResolver.method_65598(renderState.hammerItem, this.hammerItemStack, class_811.field_4319, blockEntity.method_10997(), null, 0);
        this.itemModelResolver.method_65598(renderState.firstHammerItem, blockEntity.getUpgradeStack(0), class_811.field_4319, blockEntity.method_10997(), null, 0);
        this.itemModelResolver.method_65598(renderState.secondHammerItem, blockEntity.getUpgradeStack(1), class_811.field_4319, blockEntity.method_10997(), null, 0);
        this.itemModelResolver.method_65598(renderState.item, blockEntity.getCurrentStack(), class_811.field_4319, blockEntity.method_10997(), null, 0);
    }

    public AutoHammerRenderState createRenderState() {
        return new AutoHammerRenderState();
    }

    public void submit(AutoHammerRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (renderState.skip) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 0.0f, 0.5f);
        poseStack.method_22907((Quaternionfc)renderState.facing.method_23224());
        poseStack.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)-90.0f), 0.0f, 1.0f, 0.0f)));
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        poseStack.method_22903();
        poseStack.method_46416(-0.7f, -0.3f, 0.0f);
        poseStack.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)(Math.sin((float)renderState.hammerAngle) * 30.0f)), 0.0f, 0.0f, 1.0f)));
        poseStack.method_46416(-0.4f, 0.2f, 0.0f);
        renderState.hammerItem.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
        poseStack.method_22909();
        if (!renderState.firstHammerItem.method_65606()) {
            poseStack.method_22903();
            poseStack.method_46416(-0.7f, -0.3f, 0.0f);
            poseStack.method_46416(0.0f, 0.1f, 0.33f);
            poseStack.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)10.0f), 0.0f, 1.0f, 0.0f)));
            poseStack.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)(Math.sin((float)(renderState.hammerAngle - 8.0f)) * 30.0f)), 0.0f, 0.0f, 1.0f)));
            poseStack.method_46416(-0.4f, 0.2f, 0.0f);
            renderState.firstHammerItem.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
            poseStack.method_22909();
        }
        if (!renderState.secondHammerItem.method_65606()) {
            poseStack.method_22903();
            poseStack.method_46416(-0.7f, -0.3f, 0.0f);
            poseStack.method_46416(0.0f, 0.1f, -0.33f);
            poseStack.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)-10.0f), 0.0f, 1.0f, 0.0f)));
            poseStack.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)(Math.sin((float)(renderState.hammerAngle + 8.0f)) * 30.0f)), 0.0f, 0.0f, 1.0f)));
            poseStack.method_46416(-0.4f, 0.2f, 0.0f);
            renderState.secondHammerItem.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
            poseStack.method_22909();
        }
        poseStack.method_22909();
        if (!renderState.item.method_65606()) {
            poseStack.method_22903();
            poseStack.method_22904((double)-0.4625f, (double)-0.04f, -0.2);
            poseStack.method_22905(0.4f, 0.4f, 0.4f);
            renderState.item.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
            if (renderState.progress > 0.0f) {
                // empty if block
            }
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    public static <T extends AutoHammerBlockEntity> class_827<T, AutoHammerRenderState> normal(class_5614.class_5615 context) {
        return new AutoHammerRenderer(context, false);
    }

    public static <T extends AutoHammerBlockEntity> class_827<T, AutoHammerRenderState> compressed(class_5614.class_5615 context) {
        return new AutoHammerRenderer(context, true);
    }

    public static class AutoHammerRenderState
    extends class_11954 {
        public boolean skip;
        public class_2350 facing = class_2350.field_11043;
        public float hammerAngle;
        public final class_10444 hammerItem = new class_10444();
        public final class_10444 firstHammerItem = new class_10444();
        public final class_10444 secondHammerItem = new class_10444();
        public final class_10444 item = new class_10444();
        public float progress;
    }
}

