/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.blockentity;

import java.util.UUID;
import net.blay09.mods.excompressum.block.AutoSieveBlock;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.block.entity.AbstractAutoSieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.AutoHeavySieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.AutoSieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.SieveAnimationType;
import net.blay09.mods.excompressum.client.ModModels;
import net.blay09.mods.excompressum.client.render.model.TinyHumanModel;
import net.minecraft.class_10055;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1059;
import net.minecraft.class_1068;
import net.minecraft.class_1087;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class AutoSieveRenderer<T extends AbstractAutoSieveBlockEntity>
implements class_827<T, AutoSieveRenderState> {
    private final class_776 blockRenderDispatcher;
    private final class_10442 itemModelResolver;
    private final TinyHumanModel tinyHumanModel;
    private final TinyHumanModel tinyHumanModelSlim;
    private final boolean isHeavy;
    public static int cacheKey;
    private int currentCacheKey;
    private class_1087 sieveModel;

    public AutoSieveRenderer(class_5614.class_5615 context, boolean isHeavy) {
        this.blockRenderDispatcher = context.comp_4535();
        this.itemModelResolver = context.comp_4536();
        this.tinyHumanModel = new TinyHumanModel(context.method_32140(class_5602.field_27577), false);
        this.tinyHumanModelSlim = new TinyHumanModel(context.method_32140(class_5602.field_27581), true);
        this.isHeavy = isHeavy;
    }

    public void extractRenderState(T blockEntity, AutoSieveRenderState renderState, float delta, class_243 vec, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331(blockEntity, (class_11954)renderState, delta, vec, crumblingOverlay);
        if (this.sieveModel == null || this.currentCacheKey != cacheKey) {
            this.sieveModel = this.isHeavy ? this.blockRenderDispatcher.method_3349(ModBlocks.heavySieves[0].method_9564()) : (class_1087)ModModels.sieves.get(0).get();
            this.currentCacheKey = cacheKey;
        }
        if (((AbstractAutoSieveBlockEntity)((Object)blockEntity)).shouldAnimate()) {
            float animationSpeed = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getAnimationType() == SieveAnimationType.MAGIC ? 0.05f : 0.5f;
            ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).armAngle += animationSpeed * delta;
            ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).armAngle += animationSpeed * Math.max((float)1.0f, (float)(((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getSpeedMultiplier() / 4.0f)) * delta;
        }
        renderState.skip = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).isUgly();
        renderState.progress = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getProgress();
        renderState.meshModelName = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getSieveMesh() != null ? ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getSieveMesh().getModelName() : null;
        renderState.facing = (class_2350)renderState.field_62674.method_11654((class_2769)AutoSieveBlock.FACING);
        renderState.waterlogged = (Boolean)renderState.field_62674.method_11654((class_2769)AutoSieveBlock.WATERLOGGED);
        renderState.profile = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getSkinProfile();
        renderState.armAngle = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).armAngle;
        this.itemModelResolver.method_65598(renderState.item, ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getCurrentStack(), class_811.field_4319, blockEntity.method_10997(), null, 0);
    }

    public AutoSieveRenderState createRenderState() {
        return new AutoSieveRenderState();
    }

    public void submit(AutoSieveRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        class_1087 meshModel;
        if (renderState.skip) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 0.0f, 0.5f);
        poseStack.method_22907((Quaternionfc)renderState.facing.method_23224());
        poseStack.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)-90.0f), 0.0f, 1.0f, 0.0f)));
        poseStack.method_22903();
        poseStack.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)-90.0f), 0.0f, 0.0f, 1.0f)));
        poseStack.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)90.0f), 0.0f, 1.0f, 0.0f)));
        poseStack.method_46416(0.0f, -0.65f, 0.25f);
        poseStack.method_22905(0.4f, 0.4f, 0.4f);
        class_8685 skin = this.getPlayerSkin(renderState.profile);
        TinyHumanModel playerModel = this.getPlayerModel(skin);
        playerModel.animate(renderState);
        submitNodeCollector.method_73489((class_3879)playerModel, (Object)renderState.avatar, poseStack, class_1921.method_23576((class_2960)skin.comp_1626().comp_3627()), renderState.field_62676, class_4608.field_21444, 0, renderState.field_62677);
        poseStack.method_22909();
        if (renderState.waterlogged) {
            poseStack.method_22903();
            poseStack.method_46416(-0.95f, -0.42f, -0.175f);
            float glassScale = 0.35f;
            poseStack.method_22905(glassScale, glassScale, glassScale);
            class_1087 glassModel = this.blockRenderDispatcher.method_3349(class_2246.field_10033.method_9564());
            submitNodeCollector.method_73484(poseStack, class_1921.method_23576((class_2960)class_1059.field_5275), glassModel, 1.0f, 1.0f, 1.0f, renderState.field_62676, class_4608.field_21444, 0);
            poseStack.method_22909();
        }
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        poseStack.method_46416(-0.25f, 0.0f, -0.5f);
        poseStack.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)90.0f), 0.0f, 0.0f, 1.0f)));
        poseStack.method_46416(-0.2f, -0.1f, 0.0f);
        poseStack.method_22903();
        submitNodeCollector.method_73484(poseStack, class_1921.method_23572((class_2960)class_1059.field_5275), this.sieveModel, 1.0f, 1.0f, 1.0f, renderState.field_62676, class_4608.field_21444, 0);
        poseStack.method_22909();
        class_1087 class_10872 = meshModel = renderState.meshModelName != null ? (class_1087)ModModels.meshes.get(renderState.meshModelName).get() : null;
        if (meshModel != null) {
            submitNodeCollector.method_73484(poseStack, class_1921.method_23580((class_2960)class_1059.field_5275), meshModel, 1.0f, 1.0f, 1.0f, renderState.field_62676, class_4608.field_21444, 0);
        }
        if (!renderState.item.method_65606()) {
            poseStack.method_22903();
            float contentOffset = 0.0625f;
            float meshY = 0.5625f;
            float contentScaleXZ = 0.88f;
            float contentBaseScaleY = 0.5f;
            poseStack.method_46416(0.0625f, 0.5625f, 0.0625f);
            poseStack.method_22905(0.88f, 0.5f - renderState.progress * 0.5f, 0.88f);
            renderState.item.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
            poseStack.method_22909();
        }
        poseStack.method_22909();
        poseStack.method_22909();
    }

    private class_8685 getPlayerSkin(@Nullable class_9296 profile) {
        if (profile != null) {
            return class_310.method_1551().method_73362().method_73495(profile).method_73503();
        }
        return class_1068.method_4648((UUID)UUID.randomUUID());
    }

    private TinyHumanModel getPlayerModel(@Nullable class_8685 skin) {
        if (skin != null && "slim".equals(skin.comp_1629().method_15434())) {
            return this.tinyHumanModelSlim;
        }
        return this.tinyHumanModel;
    }

    public static AutoSieveRenderer<AutoSieveBlockEntity> normal(class_5614.class_5615 context) {
        return new AutoSieveRenderer<AutoSieveBlockEntity>(context, false);
    }

    public static AutoSieveRenderer<AutoHeavySieveBlockEntity> heavy(class_5614.class_5615 context) {
        return new AutoSieveRenderer<AutoHeavySieveBlockEntity>(context, true);
    }

    public static class AutoSieveRenderState
    extends class_11954 {
        public boolean skip;
        public class_2350 facing = class_2350.field_11043;
        public boolean waterlogged;
        @Nullable
        public String meshModelName;
        public final class_10444 item = new class_10444();
        public float progress;
        @Nullable
        public class_9296 profile;
        public SieveAnimationType animationType;
        public float armAngle;
        public final class_10055 avatar = new class_10055();
    }
}

