/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.recipeviewers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.blay09.mods.excompressum.api.recipe.SieveRecipe;
import net.blay09.mods.excompressum.api.sievemesh.CommonMeshType;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.loot.LootTableEntry;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.loot.MergedLootTableEntry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;

public class ExpandedSieveRecipe {
    private final class_2960 id;
    private final SieveRecipe recipe;
    private final class_1856 ingredient;
    private final List<class_1799> meshItems;
    private final List<MergedLootTableEntry> outputs;
    private final List<class_1799> outputItems;
    private final boolean waterlogged;

    public ExpandedSieveRecipe(class_2960 id, SieveRecipe recipe) {
        this.id = id;
        this.recipe = recipe;
        this.meshItems = new ArrayList<class_1799>();
        for (CommonMeshType meshType : recipe.getMeshes()) {
            for (SieveMeshRegistryEntry mesh : SieveMeshRegistry.getEntries().values()) {
                if (mesh.getMeshType() != meshType) continue;
                this.meshItems.add(mesh.getItemStack());
            }
        }
        this.ingredient = recipe.getIngredient();
        List<LootTableEntry> entries = LootTableUtils.getLootTableEntries(recipe.getLootTable());
        this.outputs = LootTableUtils.mergeLootTableEntries(entries);
        this.outputItems = this.outputs.stream().map(MergedLootTableEntry::getItemStack).collect(Collectors.toList());
        this.waterlogged = recipe.isWaterlogged();
    }

    public SieveRecipe getRecipe() {
        return this.recipe;
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    public List<class_1799> getMeshItems() {
        return this.meshItems;
    }

    public List<MergedLootTableEntry> getOutputs() {
        return this.outputs;
    }

    public List<class_1799> getOutputItems() {
        return this.outputItems;
    }

    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    public class_2960 getId() {
        return this.id;
    }
}

