/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.handler;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.EntityAddedEvent;
import net.blay09.mods.balm.api.event.LivingDeathEvent;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.tag.ModEntityTags;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1590;
import net.minecraft.class_1613;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3730;

public class CompressedEnemyHandler {
    private static final String COMPRESSED = "Compressed";
    private static final String NOCOMPRESS = "NoCompress";

    public static void initialize() {
        Balm.getEvents().onEvent(EntityAddedEvent.class, CompressedEnemyHandler::onEntityAdded);
        Balm.getEvents().onEvent(LivingDeathEvent.class, CompressedEnemyHandler::onLivingDeath);
    }

    public static void onEntityAdded(EntityAddedEvent event) {
        class_1937 level = event.getLevel();
        class_1297 entity = event.getEntity();
        if (!level.method_8608() && entity instanceof class_1308) {
            class_2487 persistentData = Balm.getHooks().getPersistentData(entity);
            if (entity.method_5864().method_20210(ModEntityTags.COMPRESSABLE)) {
                Optional modData = persistentData.method_10562("excompressum");
                Boolean noCompress = modData.flatMap(it -> it.method_10577(NOCOMPRESS)).orElse(false);
                Boolean compressed = modData.flatMap(it -> it.method_10577(COMPRESSED)).orElse(false);
                if (noCompress.booleanValue() || compressed.booleanValue()) {
                    return;
                }
                if ((double)level.field_9229.method_43057() < ExCompressumConfig.getActive().compressedMobs.compressedMobChance) {
                    entity.method_5880(true);
                    entity.method_5665((class_2561)class_2561.method_43469((String)"tooltip.excompressum.compressed_mob", (Object[])new Object[]{entity.method_5477()}));
                    class_2487 tagCompound = new class_2487();
                    tagCompound.method_10556(COMPRESSED, true);
                    persistentData.method_10566("excompressum", (class_2520)tagCompound);
                } else {
                    class_2487 tagCompound = new class_2487();
                    tagCompound.method_10556(NOCOMPRESS, true);
                    persistentData.method_10566("excompressum", (class_2520)tagCompound);
                }
            }
        }
    }

    public static void onLivingDeath(LivingDeathEvent event) {
        class_1297 class_12972;
        class_1309 entity = event.getEntity();
        class_1937 level = entity.method_73183();
        class_1282 damageSource = event.getDamageSource();
        class_2487 persistentData = Balm.getHooks().getPersistentData((class_1297)entity);
        if (!level.method_8608() && persistentData.method_10562("excompressum").flatMap(it -> it.method_10577(COMPRESSED)).orElse(false).booleanValue() && entity instanceof class_1308 && (class_12972 = damageSource.method_5529()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (!Balm.getHooks().isFakePlayer(player)) {
                if (StupidUtils.hasSilkTouchModifier((class_1309)damageSource.method_5529())) {
                    return;
                }
                class_1299 entityType = entity.method_5864();
                for (int i = 0; i < ExCompressumConfig.getActive().compressedMobs.compressedMobSize; ++i) {
                    class_1309 zombie;
                    class_1309 newEntity = (class_1309)entityType.method_5888((class_3218)level, null, entity.method_24515(), class_3730.field_16468, false, false);
                    if (newEntity == null) {
                        return;
                    }
                    if (entity.method_6109()) {
                        if (newEntity instanceof class_1642) {
                            zombie = (class_1642)newEntity;
                            zombie.method_7217(true);
                        } else if (newEntity instanceof class_1296) {
                            class_1296 mob = (class_1296)newEntity;
                            if (entity instanceof class_1296) {
                                class_1296 from = (class_1296)entity;
                                mob.method_5614(from.method_5618());
                            }
                        }
                    }
                    Objects.requireNonNull(newEntity);
                    int mob = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1590.class, class_1613.class, class_1639.class}, (Object)zombie, mob)) {
                        case 0: {
                            class_1590 ignored = (class_1590)zombie;
                            newEntity.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
                            break;
                        }
                        case 1: {
                            class_1613 ignored = (class_1613)zombie;
                            newEntity.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
                            break;
                        }
                        case 2: {
                            class_1639 ignored = (class_1639)zombie;
                            newEntity.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8371));
                            break;
                        }
                    }
                    class_2487 tagCompound = new class_2487();
                    tagCompound.method_10556(NOCOMPRESS, true);
                    Balm.getHooks().getPersistentData((class_1297)newEntity).method_10566("excompressum", (class_2520)tagCompound);
                    newEntity.method_5808(entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), (float)Math.random(), (float)Math.random());
                    double motion = 0.01;
                    newEntity.method_18800((level.field_9229.method_43059() - 0.5) * 0.01, 0.0, (level.field_9229.method_43059() - 0.5) * 0.01);
                    level.method_8649((class_1297)newEntity);
                }
            }
        }
    }
}

