/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.loot;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.excompressum.loot.LootTableEntry;
import net.blay09.mods.excompressum.loot.MergedLootTableEntry;
import net.blay09.mods.excompressum.mixin.BinomialDistributionGeneratorAccessor;
import net.blay09.mods.excompressum.mixin.ConstantValueAccessor;
import net.blay09.mods.excompressum.mixin.LootItemAccessor;
import net.blay09.mods.excompressum.mixin.LootItemRandomChanceConditionAccessor;
import net.blay09.mods.excompressum.mixin.LootPoolAccessor;
import net.blay09.mods.excompressum.mixin.LootPoolEntryContainerAccessor;
import net.blay09.mods.excompressum.mixin.LootPoolSingletonContainerAccessor;
import net.blay09.mods.excompressum.mixin.LootTableAccessor;
import net.blay09.mods.excompressum.mixin.SetItemCountFunctionAccessor;
import net.blay09.mods.excompressum.mixin.TagEntryAccessor;
import net.blay09.mods.excompressum.mixin.UniformGeneratorAccessor;
import net.minecraft.class_10352;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_141;
import net.minecraft.class_169;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_85;
import net.minecraft.class_8567;
import net.minecraft.class_9320;
import net.minecraft.class_9331;
import net.minecraft.class_9336;
import org.jetbrains.annotations.Nullable;

public class LootTableUtils {
    private static final class_169<class_1799> SOURCE_STACK = new class_169(class_2960.method_60655((String)"excompressum", (String)"source_stack"));
    private static final class_176 CONTEXT_KEY_SET = new class_176.class_177().method_781(SOURCE_STACK).method_782();

    public static boolean isLootTableEmpty(@Nullable class_52 lootTable) {
        if (lootTable == null) {
            return true;
        }
        return LootTableUtils.getLootTableEntries(lootTable).isEmpty();
    }

    public static List<LootTableEntry> getLootTableEntries(@Nullable class_52 lootTable) {
        if (lootTable == null) {
            return Collections.emptyList();
        }
        ArrayList<LootTableEntry> result = new ArrayList<LootTableEntry>();
        List<class_55> pools = ((LootTableAccessor)lootTable).getPools();
        for (class_55 pool : pools) {
            Optional<class_5658> poolBaseChance = LootTableUtils.getBaseChance(pool);
            List<class_79> entries = ((LootPoolAccessor)pool).getEntries();
            for (class_79 entry : entries) {
                Optional<class_5658> entryBaseChance = LootTableUtils.getBaseChance(entry);
                class_5658 baseChance = entryBaseChance.orElse(poolBaseChance.orElseGet(() -> class_44.method_32448((float)1.0f)));
                class_5658 countRange = LootTableUtils.getCountRange(entry);
                if (entry instanceof LootItemAccessor) {
                    LootItemAccessor lootItem = (LootItemAccessor)entry;
                    class_1799 itemStack = new class_1799(lootItem.getItem());
                    itemStack.method_7939(Math.max(1, (int)LootTableUtils.getMaxCount(countRange)));
                    result.add(new LootTableEntry(itemStack, countRange, baseChance));
                    continue;
                }
                if (!(entry instanceof TagEntryAccessor)) continue;
                TagEntryAccessor tagEntry = (TagEntryAccessor)entry;
                class_6862<class_1792> tag = tagEntry.getTag();
                class_7923.field_41178.method_40286(tag).forEach(itemHolder -> {
                    class_1799 itemStack = new class_1799((class_1935)itemHolder.comp_349());
                    itemStack.method_7939(Math.max(1, (int)LootTableUtils.getMaxCount(countRange)));
                    result.add(new LootTableEntry(itemStack, countRange, baseChance));
                });
            }
        }
        return result;
    }

    private static Optional<class_5658> getBaseChance(class_55 pool) {
        return LootTableUtils.getBaseChance(((LootPoolAccessor)pool).getConditions());
    }

    private static Optional<class_5658> getBaseChance(class_79 entry) {
        return LootTableUtils.getBaseChance(((LootPoolEntryContainerAccessor)entry).getConditions());
    }

    private static Optional<class_5658> getBaseChance(List<class_5341> conditions) {
        for (class_5341 condition : conditions) {
            if (!(condition instanceof LootItemRandomChanceConditionAccessor)) continue;
            LootItemRandomChanceConditionAccessor chanceCondition = (LootItemRandomChanceConditionAccessor)condition;
            return Optional.of(chanceCondition.getChance());
        }
        return Optional.empty();
    }

    private static class_5658 getCountRange(class_79 entry) {
        if (entry instanceof LootPoolSingletonContainerAccessor) {
            LootPoolSingletonContainerAccessor lootPoolSingletonContainer = (LootPoolSingletonContainerAccessor)entry;
            for (class_117 function : lootPoolSingletonContainer.getFunctions()) {
                if (!(function instanceof SetItemCountFunctionAccessor)) continue;
                SetItemCountFunctionAccessor setItemCountFunction = (SetItemCountFunctionAccessor)function;
                return setItemCountFunction.getValue();
            }
        }
        return class_44.method_32448((float)1.0f);
    }

    public static float getMinCount(class_5658 range) {
        if (range instanceof UniformGeneratorAccessor) {
            UniformGeneratorAccessor uniform = (UniformGeneratorAccessor)range;
            return LootTableUtils.getMinCount(uniform.getMin());
        }
        if (range instanceof BinomialDistributionGeneratorAccessor) {
            BinomialDistributionGeneratorAccessor binomial = (BinomialDistributionGeneratorAccessor)range;
            return LootTableUtils.getMinCount(binomial.getN()) * LootTableUtils.getMaxCount(binomial.getP());
        }
        if (range instanceof ConstantValueAccessor) {
            ConstantValueAccessor constant = (ConstantValueAccessor)range;
            return constant.getValue();
        }
        return 1.0f;
    }

    public static float getMaxCount(class_5658 range) {
        if (range instanceof UniformGeneratorAccessor) {
            UniformGeneratorAccessor uniform = (UniformGeneratorAccessor)range;
            return LootTableUtils.getMaxCount(uniform.getMax());
        }
        if (range instanceof BinomialDistributionGeneratorAccessor) {
            BinomialDistributionGeneratorAccessor binomial = (BinomialDistributionGeneratorAccessor)range;
            return LootTableUtils.getMaxCount(binomial.getN()) * LootTableUtils.getMaxCount(binomial.getP());
        }
        if (range instanceof ConstantValueAccessor) {
            ConstantValueAccessor constant = (ConstantValueAccessor)range;
            return constant.getValue();
        }
        return 1.0f;
    }

    public static class_47 buildLootContext(class_3218 level, class_1799 itemStack) {
        class_10352.class_10353 params = new class_10352.class_10353();
        params.method_64970(SOURCE_STACK, (Object)itemStack);
        return new class_47.class_48(new class_8567(level, params.method_64971(CONTEXT_KEY_SET), Collections.emptyMap(), 0.0f)).method_309(Optional.empty());
    }

    public static List<MergedLootTableEntry> mergeLootTableEntries(List<LootTableEntry> entries) {
        ArrayList<MergedLootTableEntry> result = new ArrayList<MergedLootTableEntry>();
        ArrayListMultimap entryMap = ArrayListMultimap.create();
        for (LootTableEntry entry : entries) {
            if (!entry.getItemStack().method_57353().method_57837()) {
                result.add(new MergedLootTableEntry(entry));
                continue;
            }
            class_2960 itemId = class_7923.field_41178.method_10221((Object)entry.getItemStack().method_7909());
            entryMap.put((Object)itemId, (Object)entry);
        }
        for (class_2960 key : entryMap.keySet()) {
            List mergableEntries = entryMap.get((Object)key);
            LootTableEntry firstEntry = (LootTableEntry)mergableEntries.getFirst();
            result.add(new MergedLootTableEntry(firstEntry.getItemStack(), mergableEntries));
        }
        return result;
    }

    public static class_85.class_86<?> buildLootEntry(class_1799 outputItem, float chance) {
        class_85.class_86 entryBuilder = class_77.method_411((class_1935)outputItem.method_7909());
        if (outputItem.method_7947() > 0) {
            entryBuilder.method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)outputItem.method_7947())));
        }
        for (class_9336 component : outputItem.method_57353()) {
            entryBuilder.method_438(LootTableUtils.copyComponent(component));
        }
        if (chance != -1.0f) {
            entryBuilder.method_421(class_219.method_932((float)chance));
        }
        return entryBuilder;
    }

    public static class_85.class_86<?> buildLootEntry(class_1799 itemStack, class_5658 amount) {
        class_85.class_86 entryBuilder = class_77.method_411((class_1935)itemStack.method_7909());
        if (itemStack.method_7947() > 0) {
            entryBuilder.method_438((class_117.class_118)class_141.method_621((class_5658)amount));
        }
        for (class_9336 component : itemStack.method_57353()) {
            entryBuilder.method_438(LootTableUtils.copyComponent(component));
        }
        return entryBuilder;
    }

    private static <T> class_120.class_121<?> copyComponent(class_9336<T> component) {
        return class_9320.method_57650((class_9331)component.comp_2443(), (Object)component.comp_2444());
    }
}

