/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.heavysieve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.excompressum.api.recipe.HeavySieveRecipe;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.mixin.RecipeManagerAccessor;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.ModRecipeTypes;
import net.blay09.mods.excompressum.registry.heavysieve.GeneratedHeavySieveRecipe;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRecipeImpl;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.class_10289;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

public class HeavySieveRegistry {
    private static boolean testRecipe(SieveMeshRegistryEntry mesh, class_1799 itemStack, boolean waterlogged, HeavySieveRecipe recipe) {
        if (recipe.isWaterlogged() != waterlogged) {
            return false;
        }
        if (!recipe.getMeshes().isEmpty() && !recipe.getMeshes().contains((Object)mesh.getMeshType())) {
            return false;
        }
        return recipe.getIngredient().method_8093(itemStack);
    }

    private static boolean testGeneratedRecipe(class_1937 level, class_1799 itemStack, GeneratedHeavySieveRecipe generatedRecipe, class_2680 sieve, SieveMeshRegistryEntry sieveMesh) {
        class_2248 sourceBlock = (class_2248)class_7923.field_41175.method_63535(generatedRecipe.getSourceItem());
        return generatedRecipe.getIngredient().method_8093(itemStack) && ExNihilo.isSiftableWithMesh(level, sieve, new class_1799((class_1935)sourceBlock), sieveMesh);
    }

    public static List<class_1799> rollSieveRewards(class_1937 level, class_47 context, class_2680 sieve, SieveMeshRegistryEntry mesh, class_1799 itemStack) {
        boolean waterlogged = sieve.method_28498((class_2769)class_2741.field_12508) && (Boolean)sieve.method_11654((class_2769)class_2741.field_12508) != false;
        class_1863 recipeManager = context.method_299().method_8503().method_3772();
        class_10289 recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.method_64698(ModRecipeTypes.heavySieveRecipeType);
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        for (Object recipeHolder : recipes) {
            class_52 lootTable;
            HeavySieveRecipeImpl recipe = (HeavySieveRecipeImpl)recipeHolder.comp_1933();
            if (!HeavySieveRegistry.testRecipe(mesh, itemStack, waterlogged, recipe) || (lootTable = recipe.getLootTable()) == null) continue;
            lootTable.method_320(context, results::add);
        }
        Collection generatedRecipes = recipeMap.method_64698(ModRecipeTypes.generatedHeavySieveRecipeType);
        for (class_8786 recipeHolder : generatedRecipes) {
            GeneratedHeavySieveRecipe recipe = (GeneratedHeavySieveRecipe)recipeHolder.comp_1933();
            if (!HeavySieveRegistry.testGeneratedRecipe(level, itemStack, recipe, sieve, mesh)) continue;
            int rolls = HeavySieveRegistry.getGeneratedRollCount(recipe);
            class_1935 source = (class_1935)class_7923.field_41178.method_63535(recipe.getSourceItem());
            class_52 lootTable = ExNihilo.getInstance().generateHeavySieveLootTable(level, sieve, source, rolls, mesh);
            if (lootTable == null) continue;
            lootTable.method_320(context, results::add);
        }
        class_2680 inputState = StupidUtils.getStateFromItemStack(itemStack);
        results.addAll(ExNihilo.getInstance().rollHeavySieveRewards(level, sieve, inputState, mesh, context.method_302(), level.field_9229));
        return results;
    }

    public static Integer getGeneratedRollCount(GeneratedHeavySieveRecipe generatedRecipe) {
        return generatedRecipe.getRolls() > 0 ? generatedRecipe.getRolls() : ExCompressumConfig.getActive().general.heavySieveDefaultRolls;
    }

    public boolean isSiftable(class_3218 level, class_2680 sieve, class_1799 itemStack, SieveMeshRegistryEntry sieveMesh) {
        boolean waterlogged = sieve.method_28498((class_2769)class_2741.field_12508) && (Boolean)sieve.method_11654((class_2769)class_2741.field_12508) != false;
        class_1863 recipeManager = level.method_8503().method_3772();
        class_10289 recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.method_64698(ModRecipeTypes.heavySieveRecipeType);
        for (Object recipeHolder : recipes) {
            HeavySieveRecipeImpl recipe = (HeavySieveRecipeImpl)recipeHolder.comp_1933();
            if (!HeavySieveRegistry.testRecipe(sieveMesh, itemStack, waterlogged, recipe)) continue;
            return true;
        }
        Collection generatedRecipes = recipeMap.method_64698(ModRecipeTypes.generatedHeavySieveRecipeType);
        for (class_8786 recipeHolder : generatedRecipes) {
            GeneratedHeavySieveRecipe recipe = (GeneratedHeavySieveRecipe)recipeHolder.comp_1933();
            if (!HeavySieveRegistry.testGeneratedRecipe((class_1937)level, itemStack, recipe, sieve, sieveMesh)) continue;
            return true;
        }
        class_2680 state = StupidUtils.getStateFromItemStack(itemStack);
        return ExNihilo.getInstance().isHeavySiftableWithMesh(sieve, state, sieveMesh);
    }
}

