/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.event;

import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.benbenlaw.inworldrecipes.recipes.BlockInteractionRecipe;
import com.benbenlaw.inworldrecipes.recipes.BlockTarget;
import com.benbenlaw.inworldrecipes.util.ClickType;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="inworldrecipes")
public class BlockInteractionEvent {
    @SubscribeEvent
    public static void rightClickOnBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (level.isClientSide()) {
            return;
        }
        for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)BlockInteractionRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
            if (((BlockInteractionRecipe)match.value()).clickType() != ClickType.RIGHT_CLICK) continue;
            BlockInteractionEvent.executeBlockInteractionEvent(level, player, pos, hand, (RecipeHolder<BlockInteractionRecipe>)match);
        }
    }

    @SubscribeEvent
    public static void leftClickOnBlock(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (level.isClientSide()) {
            return;
        }
        for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)BlockInteractionRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
            if (((BlockInteractionRecipe)match.value()).clickType() != ClickType.LEFT_CLICK || event.getAction() != PlayerInteractEvent.LeftClickBlock.Action.START) continue;
            BlockInteractionEvent.executeBlockInteractionEvent(level, player, pos, hand, (RecipeHolder<BlockInteractionRecipe>)match);
        }
    }

    public static void executeBlockInteractionEvent(Level level, Player player, BlockPos pos, InteractionHand hand, RecipeHolder<BlockInteractionRecipe> match) {
        block6: {
            SizedIngredient recipeHeldItem;
            BlockState levelTargetBlockState;
            BlockTarget recipeTarget = ((BlockInteractionRecipe)match.value()).targetBlock();
            boolean matches = recipeTarget.matches(levelTargetBlockState = level.getBlockState(pos), ((BlockInteractionRecipe)match.value()).ignoreBlockState());
            if (!matches || !(recipeHeldItem = ((BlockInteractionRecipe)match.value()).heldItem()).test(player.getItemInHand(hand))) break block6;
            BlockState recipeOutputBlockState = ((BlockInteractionRecipe)match.value()).outputBlockState();
            List<ItemStack> resultItems = ((BlockInteractionRecipe)match.value()).rollResults(level.random);
            level.setBlockAndUpdate(pos, Objects.requireNonNullElseGet(recipeOutputBlockState, () -> ((Block)Blocks.AIR).defaultBlockState()));
            if (((BlockInteractionRecipe)match.value()).damageHeldItem()) {
                player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.valueOf((String)hand.name().replace("_", "").toUpperCase()));
            }
            if (((BlockInteractionRecipe)match.value()).consumeHeldItem()) {
                player.getItemInHand(hand).shrink(((BlockInteractionRecipe)match.value()).heldItem().count());
            }
            if (((BlockInteractionRecipe)match.value()).popItems()) {
                for (ItemStack itemStack : resultItems) {
                    if (itemStack.isEmpty()) continue;
                    BlockInteractionEvent.popOutTheItem(level, pos, itemStack);
                }
            } else {
                for (ItemStack itemStack : resultItems) {
                    if (itemStack.isEmpty()) continue;
                    player.getInventory().placeItemBackInInventory(itemStack);
                }
            }
        }
    }

    public static void popOutTheItem(Level level, BlockPos blockPos, ItemStack itemStack) {
        Vec3 vec3 = Vec3.atLowerCornerWithOffset((Vec3i)blockPos, (double)0.5, (double)0.5, (double)0.5).offsetRandom(level.random, 0.7f);
        ItemStack itemstack1 = itemStack.copy();
        ItemEntity itementity = new ItemEntity(level, vec3.x(), vec3.y(), vec3.z(), itemstack1);
        itementity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)itementity);
    }
}

