/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.integration.jei;

import com.benbenlaw.inworldrecipes.integration.jei.JEIInWorldRecipesPlugin;
import com.benbenlaw.inworldrecipes.recipes.BlockConversionRecipe;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockConversionRecipeCategory
implements IRecipeCategory<BlockConversionRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"inworldrecipes", (String)"block_conversion");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"inworldrecipes", (String)"textures/gui/jei_block_conversion.png");
    static final RecipeType<BlockConversionRecipe> RECIPE_TYPE = RecipeType.create((String)"inworldrecipes", (String)"block_conversion", BlockConversionRecipe.class);
    int yOffset = 21;
    int totalMessages;
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;

    @Nullable
    public ResourceLocation getRegistryName(BlockConversionRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)BlockConversionRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((BlockConversionRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public BlockConversionRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 139, 18);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK));
    }

    @NotNull
    public RecipeType<BlockConversionRecipe> getRecipeType() {
        return JEIInWorldRecipesPlugin.BLOCK_CONVERSION_RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"In World Conversion");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BlockConversionRecipe recipe, @NotNull IFocusGroup focusGroup) {
        this.totalMessages = 1;
        ItemStack blockToConvert = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)recipe.blockToConvert()))).asItem().getDefaultInstance();
        ItemStack convertedBlock = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)recipe.convertedBlock()))).asItem().getDefaultInstance();
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 2).addItemStack(blockToConvert);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 84, 2).addItemStack(convertedBlock);
        if (recipe.requiresSunlight()) {
            ++this.totalMessages;
        }
        if (recipe.requiresMoonlight()) {
            ++this.totalMessages;
        }
        if (recipe.popBlock()) {
            ++this.totalMessages;
        }
        if (!recipe.dimension().isBlank()) {
            ++this.totalMessages;
        }
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, 139, 18 + this.totalMessages * 10);
    }

    public void draw(BlockConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.yOffset = 20;
        if (recipe.requiresMoonlight()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Converts at Night", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.requiresSunlight()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Coverts in Day Light", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.popBlock()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Block Drops In World", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (!recipe.dimension().isBlank()) {
            if (recipe.dimension().contains("none")) {
                guiGraphics.drawString(Minecraft.getInstance().font, "In: Any Dimension", 0, this.yOffset, Color.GRAY.getRGB(), false);
            } else {
                guiGraphics.drawString(Minecraft.getInstance().font, "In: " + recipe.dimension(), 0, this.yOffset, Color.GRAY.getRGB(), false);
            }
            this.yOffset += 10;
        }
        if (recipe.duration() > 0) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Duration: " + recipe.duration() + " ticks", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
    }
}

