/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.integration.jei;

import com.benbenlaw.inworldrecipes.MouseUtil;
import com.benbenlaw.inworldrecipes.integration.jei.JEIInWorldRecipesPlugin;
import com.benbenlaw.inworldrecipes.recipes.RightClickOnEntityTransformsItemRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class RightClickOnEntityTransformsItemRecipeCategory
implements IRecipeCategory<RightClickOnEntityTransformsItemRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"inworldrecipes", (String)"right_click_on_entity_transforms_item");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"inworldrecipes", (String)"textures/gui/jei_right_click_on_entity_item.png");
    static final RecipeType<RightClickOnEntityTransformsItemRecipe> RECIPE_TYPE = RecipeType.create((String)"inworldrecipes", (String)"right_click_on_entity_transforms_item", RightClickOnEntityTransformsItemRecipe.class);
    int yOffset = 21;
    int totalMessages;
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private double previousMouseX = 0.0;
    private double previousMouseY = 0.0;
    private float entityYaw = 0.0f;
    private float entityPitch = 0.0f;

    @Nullable
    public ResourceLocation getRegistryName(RightClickOnEntityTransformsItemRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RightClickOnEntityTransformsItemRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((RightClickOnEntityTransformsItemRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public RightClickOnEntityTransformsItemRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 139, 18);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK));
    }

    @NotNull
    public RecipeType<RightClickOnEntityTransformsItemRecipe> getRecipeType() {
        return JEIInWorldRecipesPlugin.RIGHT_CLICK_ON_ENTITY_TRANSFORM_ITEM_RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Right Click On Entity");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RightClickOnEntityTransformsItemRecipe recipe, @NotNull IFocusGroup focusGroup) {
        this.totalMessages = 0;
        builder.addSlot(RecipeIngredientRole.CATALYST, 4, 2).addItemStacks(Arrays.asList(recipe.heldItem().getItems()));
        List<ItemStack> results = recipe.getResults();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 2).addItemStacks(results);
        if (recipe.damageHeldItem()) {
            ++this.totalMessages;
        }
        if (recipe.consumeHeldItem()) {
            ++this.totalMessages;
        }
        if (recipe.popItem()) {
            ++this.totalMessages;
        }
        if (recipe.destroyEntity()) {
            ++this.totalMessages;
        }
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, 139, 18 + this.totalMessages * 10);
    }

    public void draw(RightClickOnEntityTransformsItemRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.yOffset = 20;
        Entity entity = ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)recipe.entity()))).create((Level)Minecraft.getInstance().level);
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, 0, 0, 40, 2, 16, 16)) {
            assert (entity != null);
            guiGraphics.renderTooltip(Minecraft.getInstance().font, entity.getName(), (int)mouseX, (int)mouseY);
        }
        assert (Minecraft.getInstance().level != null);
        assert (entity != null);
        float scale = 10.0f;
        if (entity instanceof EnderDragon) {
            scale = 5.0f;
        }
        if (entity instanceof EnderMan) {
            scale = 7.0f;
        }
        double deltaX = mouseX - this.previousMouseX;
        double deltaY = mouseY - this.previousMouseY;
        this.entityYaw += (float)(deltaX * 0.5);
        this.entityPitch = (float)Math.max(-45.0, Math.min(45.0, (double)this.entityPitch + (double)((float)deltaY) * 0.5));
        this.previousMouseX = mouseX;
        this.previousMouseY = mouseY;
        this.renderEntityInCategory(guiGraphics, 48, 18, scale, this.entityYaw, this.entityPitch, entity);
        if (recipe.damageHeldItem()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Damages Item", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.consumeHeldItem()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Consumes Item", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.popItem()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Item Drops In World", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.destroyEntity()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Destroys Entity", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
    }

    private void renderEntityInCategory(GuiGraphics guiGraphics, int x, int y, double scale, float yaw, float pitch, Entity entity) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)x, (double)y, 50.0);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        entity.setYBodyRot(yaw);
        entity.setYRot(yaw);
        entity.setYHeadRot(yaw);
        entity.setXRot(pitch);
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        entityRenderDispatcher.overrideCameraOrientation(new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f));
        entityRenderDispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.endBatch();
        entityRenderDispatcher.setRenderShadow(true);
        poseStack.popPose();
    }
}

