/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.recipes;

import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record DropItemInFluidConvertsFluidRecipe(SizedIngredient droppedItem, String fluid, String newFluid, boolean destroyItems) implements Recipe<NoInventoryRecipe>
{
    public boolean matches(NoInventoryRecipe p_346065_, Level p_345375_) {
        return true;
    }

    public ItemStack assemble(NoInventoryRecipe p_345149_, HolderLookup.Provider p_346030_) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<DropItemInFluidConvertsFluidRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<DropItemInFluidConvertsFluidRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.fieldOf("dropped_item").forGetter(DropItemInFluidConvertsFluidRecipe::droppedItem), (App)Codec.STRING.fieldOf("fluid").forGetter(DropItemInFluidConvertsFluidRecipe::fluid), (App)Codec.STRING.fieldOf("new_fluid").forGetter(DropItemInFluidConvertsFluidRecipe::newFluid), (App)Codec.BOOL.fieldOf("destroy_items").forGetter(DropItemInFluidConvertsFluidRecipe::destroyItems)).apply((Applicative)instance, DropItemInFluidConvertsFluidRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, DropItemInFluidConvertsFluidRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<DropItemInFluidConvertsFluidRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, DropItemInFluidConvertsFluidRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static DropItemInFluidConvertsFluidRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient droppedItem = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            String fluid = buffer.readUtf();
            String newFluid = buffer.readUtf();
            boolean destroyItems = buffer.readBoolean();
            return new DropItemInFluidConvertsFluidRecipe(droppedItem, fluid, newFluid, destroyItems);
        }

        private static void write(RegistryFriendlyByteBuf buffer, DropItemInFluidConvertsFluidRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.droppedItem);
            buffer.writeUtf(recipe.fluid);
            buffer.writeUtf(recipe.newFluid);
            buffer.writeBoolean(recipe.destroyItems);
        }
    }

    public static class Type
    implements RecipeType<DropItemInFluidConvertsFluidRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

