/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.recipes;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record DropItemInFluidRecipe(NonNullList<SizedIngredient> droppedItems, String fluid, boolean consumeFluidBlock, NonNullList<ChanceResult> chanceResults) implements Recipe<NoInventoryRecipe>
{
    public boolean matches(NoInventoryRecipe p_346065_, Level p_345375_) {
        return true;
    }

    public ItemStack assemble(NoInventoryRecipe p_345149_, HolderLookup.Provider p_346030_) {
        return ((ChanceResult)this.chanceResults.get(0)).stack().copy();
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return ((ChanceResult)this.chanceResults.get(0)).stack();
    }

    public List<ItemStack> getResults() {
        return this.getRollResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public NonNullList<ChanceResult> getRollResults() {
        return this.chanceResults;
    }

    public NonNullList<SizedIngredient> getDroppedItems() {
        return this.droppedItems;
    }

    public List<ItemStack> rollResults(RandomSource rand) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<ChanceResult> rollResults = this.getRollResults();
        for (ChanceResult output : rollResults) {
            ItemStack stack = output.rollOutput(rand);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<DropItemInFluidRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<DropItemInFluidRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)SizedIngredient.FLAT_CODEC).fieldOf("dropped_items").flatXmap(sizedIngredients -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)sizedIngredients);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(DropItemInFluidRecipe::getDroppedItems), (App)Codec.STRING.fieldOf("fluid").forGetter(DropItemInFluidRecipe::fluid), (App)Codec.BOOL.fieldOf("consume_fluid").forGetter(DropItemInFluidRecipe::consumeFluidBlock), (App)Codec.list((Codec)ChanceResult.CODEC).fieldOf("results").flatXmap(chanceResults -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)chanceResults);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(DropItemInFluidRecipe::getRollResults)).apply((Applicative)instance, DropItemInFluidRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, DropItemInFluidRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<DropItemInFluidRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, DropItemInFluidRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static DropItemInFluidRecipe read(RegistryFriendlyByteBuf buffer) {
            int droppedItemSize = buffer.readVarInt();
            NonNullList droppedItems = NonNullList.create();
            for (int i = 0; i < droppedItemSize; ++i) {
                droppedItems.add((Object)((SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer)));
            }
            String fluid = buffer.readUtf();
            boolean consumeFluidBlock = buffer.readBoolean();
            int size = buffer.readVarInt();
            NonNullList outputs = NonNullList.create();
            for (int i = 0; i < size; ++i) {
                outputs.add((Object)ChanceResult.read((RegistryFriendlyByteBuf)buffer));
            }
            return new DropItemInFluidRecipe((NonNullList<SizedIngredient>)droppedItems, fluid, consumeFluidBlock, (NonNullList<ChanceResult>)outputs);
        }

        private static void write(RegistryFriendlyByteBuf buffer, DropItemInFluidRecipe recipe) {
            buffer.writeVarInt(recipe.droppedItems.size());
            for (SizedIngredient output : recipe.droppedItems) {
                SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)output);
            }
            buffer.writeUtf(recipe.fluid);
            buffer.writeBoolean(recipe.consumeFluidBlock);
            buffer.writeVarInt(recipe.chanceResults.size());
            for (SizedIngredient output : recipe.chanceResults) {
                output.write(buffer);
            }
        }
    }

    public static class Type
    implements RecipeType<DropItemInFluidRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

