/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.recipes;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record RightClickOnEntityTransformsItemRecipe(SizedIngredient heldItem, String entity, boolean damageHeldItem, boolean consumeHeldItem, boolean destroyEntity, boolean popItem, NonNullList<ChanceResult> chanceResults) implements Recipe<NoInventoryRecipe>
{
    public boolean matches(NoInventoryRecipe p_346065_, Level p_345375_) {
        return true;
    }

    public ItemStack assemble(NoInventoryRecipe p_345149_, HolderLookup.Provider p_346030_) {
        return ((ChanceResult)this.chanceResults.get(0)).stack().copy();
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return ((ChanceResult)this.chanceResults.get(0)).stack();
    }

    public List<ItemStack> getResults() {
        return this.getRollResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public NonNullList<ChanceResult> getRollResults() {
        return this.chanceResults;
    }

    public List<ItemStack> rollResults(RandomSource rand) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<ChanceResult> rollResults = this.getRollResults();
        for (ChanceResult output : rollResults) {
            ItemStack stack = output.rollOutput(rand);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<RightClickOnEntityTransformsItemRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<RightClickOnEntityTransformsItemRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.fieldOf("held_item").forGetter(RightClickOnEntityTransformsItemRecipe::heldItem), (App)Codec.STRING.fieldOf("entity").forGetter(RightClickOnEntityTransformsItemRecipe::entity), (App)Codec.BOOL.fieldOf("damage_held_item").forGetter(RightClickOnEntityTransformsItemRecipe::damageHeldItem), (App)Codec.BOOL.fieldOf("consume_held_item").forGetter(RightClickOnEntityTransformsItemRecipe::consumeHeldItem), (App)Codec.BOOL.fieldOf("destroy_entity").forGetter(RightClickOnEntityTransformsItemRecipe::destroyEntity), (App)Codec.BOOL.fieldOf("pop_item").forGetter(RightClickOnEntityTransformsItemRecipe::popItem), (App)Codec.list((Codec)ChanceResult.CODEC).fieldOf("results").flatXmap(chanceResults -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)chanceResults);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(RightClickOnEntityTransformsItemRecipe::getRollResults)).apply((Applicative)instance, RightClickOnEntityTransformsItemRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, RightClickOnEntityTransformsItemRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<RightClickOnEntityTransformsItemRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, RightClickOnEntityTransformsItemRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static RightClickOnEntityTransformsItemRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient heldItem = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            String entity = buffer.readUtf();
            boolean damageHeldItem = buffer.readBoolean();
            boolean consumeHeldItem = buffer.readBoolean();
            boolean destroyEntity = buffer.readBoolean();
            boolean popItem = buffer.readBoolean();
            int size = buffer.readVarInt();
            NonNullList outputs = NonNullList.withSize((int)size, (Object)ChanceResult.EMPTY);
            outputs.replaceAll(ignored -> ChanceResult.read((RegistryFriendlyByteBuf)buffer));
            return new RightClickOnEntityTransformsItemRecipe(heldItem, entity, damageHeldItem, consumeHeldItem, destroyEntity, popItem, (NonNullList<ChanceResult>)outputs);
        }

        private static void write(RegistryFriendlyByteBuf buffer, RightClickOnEntityTransformsItemRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.heldItem);
            buffer.writeUtf(recipe.entity);
            buffer.writeBoolean(recipe.damageHeldItem);
            buffer.writeBoolean(recipe.consumeHeldItem);
            buffer.writeBoolean(recipe.destroyEntity);
            buffer.writeBoolean(recipe.popItem);
            buffer.writeVarInt(recipe.chanceResults.size());
            for (ChanceResult output : recipe.chanceResults) {
                output.write(buffer);
            }
        }
    }

    public static class Type
    implements RecipeType<RightClickOnEntityTransformsItemRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

