/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.bpopener;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.util.IngredientMap;
import io.bluebeaker.bpopener.OpenAction;
import java.util.List;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bpopener.BPOpener")
@ZenRegister
public class BPOEntries {
    private static final IngredientMap<OpenAction> OPEN_ACTIONS = new IngredientMap();

    @ZenMethod
    public static void addEntry(IIngredient ingredient, boolean sneaking) {
        OpenAction action = sneaking ? OpenAction.SNEAK_USE : OpenAction.USE;
        CraftTweakerAPI.apply((IAction)new AddBPOAction(ingredient, action));
    }

    public static OpenAction getOpenAction(IItemStack item) {
        List actions = OPEN_ACTIONS.getEntries(item);
        if (actions.size() > 0) {
            return (OpenAction)((Object)actions.get(0));
        }
        return null;
    }

    private static class AddBPOAction
    implements IAction {
        private final IIngredient ingredient;
        private final OpenAction function;

        public AddBPOAction(IIngredient ingredient, OpenAction function) {
            this.ingredient = ingredient;
            this.function = function;
        }

        public void apply() {
            OPEN_ACTIONS.register(this.ingredient, (Object)this.function);
        }

        public String describe() {
            return "Adding open action for " + this.ingredient;
        }
    }
}

