/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli;

import com.google.gson.Gson;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lolicode.nekomusiccli.cache.CacheUtils;
import org.lolicode.nekomusiccli.config.ModConfig;
import org.lolicode.nekomusiccli.hud.HudUtils;
import org.lolicode.nekomusiccli.integration.plasmovoice.NekoMusicPVAddon;
import org.lolicode.nekomusiccli.integration.plasmovoice.PVAddonLoader;
import org.lolicode.nekomusiccli.music.MusicManager;
import org.lolicode.nekomusiccli.network.NetUtils;
import org.lolicode.nekomusiccli.packet.ClientByeSender;
import org.lolicode.nekomusiccli.packet.ClientHelloSender;
import org.lolicode.nekomusiccli.packet.ServerPacketReceiver;

@Mod(value="nekomusiccli")
public class NekoMusicClient {
    public static final String MOD_ID = "nekomusiccli";
    public static final String MOD_NAME = "NekoMusic Client";
    public static final String MOD_CHANNEL = "nekomusic";
    public static final ResourceLocation MOD_BASE_IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"nekomusic", (String)"nekomusiccli");
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Gson GSON = new Gson();
    public static MusicManager musicManager;
    public static HudUtils hudUtils;
    public static CacheUtils cacheUtils;
    public static ModConfig config;
    public static NetUtils netUtils;
    public static NekoMusicPVAddon pvAddon;

    public NekoMusicClient(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::clientSetup);
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (container, parent) -> (Screen)AutoConfig.getConfigScreen(ModConfig.class, (Screen)parent).get());
    }

    @SubscribeEvent
    private void clientSetup(FMLClientSetupEvent event) {
        ModContainer pvModContainer;
        cacheUtils = new CacheUtils(config);
        netUtils = new NetUtils(config);
        musicManager = new MusicManager();
        hudUtils = new HudUtils();
        ServerPacketReceiver.register();
        ClientHelloSender.register();
        ClientByeSender.register();
        if (NekoMusicClient.config.lowerVolumeWhenPlayingVoice && ModList.get().isLoaded("plasmovoice") && (pvModContainer = (ModContainer)ModList.get().getModContainerById("plasmovoice").orElse(null)) != null) {
            String version = pvModContainer.getModInfo().getVersion().toString();
            try {
                if (version.compareTo("2.1.0") >= 0) {
                    PVAddonLoader.load();
                } else {
                    LOGGER.warn("PlasmoVoice version is too low, PlasmoVoice integration will not be loaded.");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        hudUtils = null;
        cacheUtils = null;
        pvAddon = null;
    }
}

