/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.lolicode.nekomusiccli.libs.flac.common.StreamInfo;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;
import org.lolicode.nekomusiccli.libs.flac.encode.FrameEncoder;
import org.lolicode.nekomusiccli.libs.flac.encode.SizeEstimate;
import org.lolicode.nekomusiccli.libs.flac.encode.SubframeEncoder;

public final class AdvancedFlacEncoder {
    public AdvancedFlacEncoder(StreamInfo info, int[][] samples, int baseSize, int[] sizeMultiples, SubframeEncoder.SearchOptions opts, BitOutputStream out) throws IOException {
        int pos;
        int numSamples = samples[0].length;
        SizeEstimate[][] encoderInfo = new SizeEstimate[sizeMultiples.length][(numSamples + baseSize - 1) / baseSize];
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < encoderInfo[0].length; ++i) {
            double progress = (double)i / (double)encoderInfo[0].length;
            double timeRemain = (double)(System.currentTimeMillis() - startTime) / 1000.0 / progress * (1.0 - progress);
            System.err.printf("\rprogress=%.2f%%    timeRemain=%ds", progress * 100.0, Math.round(timeRemain));
            pos = i * baseSize;
            for (int j = 0; j < encoderInfo.length; ++j) {
                int n = Math.min(sizeMultiples[j] * baseSize, numSamples - pos);
                long[][] subsamples = AdvancedFlacEncoder.getRange(samples, pos, n);
                encoderInfo[j][i] = FrameEncoder.computeBest(pos, subsamples, info.sampleDepth, info.sampleRate, opts);
            }
        }
        System.err.println();
        FrameEncoder[] bestEncoders = new FrameEncoder[encoderInfo[0].length];
        long[] bestSizes = new long[bestEncoders.length];
        Arrays.fill(bestSizes, Long.MAX_VALUE);
        for (int i = 0; i < encoderInfo.length; ++i) {
            for (int j = bestSizes.length - 1; j >= 0; --j) {
                long size = encoderInfo[i][j].sizeEstimate;
                if (j + sizeMultiples[i] < bestSizes.length) {
                    size += bestSizes[j + sizeMultiples[i]];
                }
                if (size >= bestSizes[j]) continue;
                bestSizes[j] = size;
                bestEncoders[j] = (FrameEncoder)encoderInfo[i][j].encoder;
            }
        }
        info.minBlockSize = 0;
        info.maxBlockSize = 0;
        info.minFrameSize = 0;
        info.maxFrameSize = 0;
        ArrayList<Integer> blockSizes = new ArrayList<Integer>();
        int i = 0;
        while (i < bestEncoders.length) {
            FrameEncoder enc = bestEncoders[i];
            pos = i * baseSize;
            int n = Math.min(enc.metadata.blockSize, numSamples - pos);
            blockSizes.add(n);
            if (info.minBlockSize == 0 || n < info.minBlockSize) {
                info.minBlockSize = Math.max(n, 16);
            }
            info.maxBlockSize = Math.max(n, info.maxBlockSize);
            long[][] subsamples = AdvancedFlacEncoder.getRange(samples, pos, n);
            long startByte = out.getByteCount();
            bestEncoders[i].encode(subsamples, out);
            i += (n + baseSize - 1) / baseSize;
            long frameSize = out.getByteCount() - startByte;
            if (frameSize < 0L || (long)((int)frameSize) != frameSize) {
                throw new AssertionError();
            }
            if (info.minFrameSize == 0 || frameSize < (long)info.minFrameSize) {
                info.minFrameSize = (int)frameSize;
            }
            if (frameSize <= (long)info.maxFrameSize) continue;
            info.maxFrameSize = (int)frameSize;
        }
    }

    private static long[][] getRange(int[][] array, int off, int len) {
        long[][] result = new long[array.length][len];
        for (int i = 0; i < array.length; ++i) {
            int[] src = array[i];
            long[] dest = result[i];
            for (int j = 0; j < len; ++j) {
                dest[j] = src[off + j];
            }
        }
        return result;
    }
}

