/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.io.IOException;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;
import org.lolicode.nekomusiccli.libs.flac.encode.SizeEstimate;
import org.lolicode.nekomusiccli.libs.flac.encode.SubframeEncoder;

final class ConstantEncoder
extends SubframeEncoder {
    public static SizeEstimate<SubframeEncoder> computeBest(long[] samples, int shift, int depth) {
        if (!ConstantEncoder.isConstant(samples)) {
            return null;
        }
        ConstantEncoder enc = new ConstantEncoder(samples, shift, depth);
        long size = 8 + shift + depth;
        return new SizeEstimate<SubframeEncoder>(size, enc);
    }

    public ConstantEncoder(long[] samples, int shift, int depth) {
        super(shift, depth);
    }

    @Override
    public void encode(long[] samples, BitOutputStream out) throws IOException {
        if (!ConstantEncoder.isConstant(samples)) {
            throw new IllegalArgumentException("Data is not constant-valued");
        }
        if (samples[0] >> this.sampleShift << this.sampleShift != samples[0]) {
            throw new IllegalArgumentException("Invalid shift value for data");
        }
        this.writeTypeAndShift(0, out);
        this.writeRawSample(samples[0] >> this.sampleShift, out);
    }

    private static boolean isConstant(long[] data) {
        if (data.length == 0) {
            return false;
        }
        long val = data[0];
        for (long x : data) {
            if (x == val) continue;
            return false;
        }
        return true;
    }
}

