/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.lrcparser.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lolicode.nekomusiccli.libs.lrcparser.parser.Sentence;

public class LyricParser {
    private BufferedReader reader;
    private Hashtable<String, String> tags;
    private ArrayList<Sentence> sentences;
    private Pattern numberPattern;

    public static LyricParser create(BufferedReader reader) throws IOException {
        LyricParser parser = new LyricParser(reader);
        return LyricParser.create(parser);
    }

    private static LyricParser create(LyricParser parser) throws IOException {
        parser.parse();
        parser.close();
        return parser;
    }

    public LyricParser(BufferedReader reader) {
        this.reader = reader;
        this.sentences = new ArrayList(25);
        this.tags = new Hashtable(0);
        this.numberPattern = Pattern.compile("[0-9]+");
    }

    private int checkLine(String line) throws LyricParseException {
        if (line.length() < 3 || !"[".equals(line.substring(0, 1))) {
            throw new LyricParseException(line);
        }
        int posBracketRight = line.indexOf("]");
        if (posBracketRight < 2) {
            throw new LyricParseException(line);
        }
        return posBracketRight;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private String[] extractTime(String line) throws LyricParseException {
        int posBracketRight = this.checkLine(line);
        String time = line.substring(1, posBracketRight);
        String[] ts = time.split("\\:", 2);
        if (ts.length < 2) {
            throw new LyricParseException(line);
        }
        String[] result = new String[2];
        if (this.isNumber(ts[0])) {
            result[0] = "" + LyricParser.parseTime(ts);
            result[1] = line.substring(posBracketRight + 1);
        } else if (!this.isNumber(ts[0])) {
            result = ts;
        }
        return result;
    }

    public ArrayList<Sentence> getSentences() {
        return this.sentences;
    }

    public Hashtable<String, String> getTags() {
        return this.tags;
    }

    private boolean isNumber(String str) {
        Matcher isNum = this.numberPattern.matcher(str);
        return isNum.matches();
    }

    private void organize() {
        Collections.sort(this.sentences, new Sentence.SentenceComparator());
        int size = this.sentences.size();
        for (int i = 0; i < size; ++i) {
            this.sentences.get(i).setIndex(i);
            if (i >= size - 1) continue;
            long toTime = this.sentences.get(i + 1).getFromTime() - 1L;
            this.sentences.get(i).setToTime(toTime);
        }
    }

    public void parse() throws IOException {
        String temp = null;
        while ((temp = this.reader.readLine()) != null) {
            this.parseLine(temp.trim());
        }
        this.organize();
    }

    private void parseLine(String line) {
        ArrayList<Sentence> sentences = new ArrayList<Sentence>(2);
        String time = "";
        try {
            while (true) {
                String[] timeAndContent = this.extractTime(line);
                time = timeAndContent[0];
                line = timeAndContent[1];
                if (!this.isNumber(time)) {
                    this.tags.put(time, line);
                    break;
                }
                Sentence sent = new Sentence(Long.parseLong(time));
                sentences.add(sent);
            }
        }
        catch (LyricParseException e) {
            // empty catch block
        }
        for (Sentence sent : sentences) {
            sent.setContent(line);
        }
        this.sentences.addAll(sentences);
        sentences = null;
    }

    public static long parseTime(String[] ts) throws LyricParseException {
        double seconds;
        try {
            seconds = Double.parseDouble(ts[1]);
        }
        catch (NumberFormatException e) {
            throw new LyricParseException(ts[1]);
        }
        double s = (double)(Integer.parseInt(ts[0]) * 60) + seconds;
        return Math.round(s * 1000.0);
    }

    private static class LyricParseException
    extends Exception {
        private static final long serialVersionUID = -4668849369948178657L;

        public LyricParseException(String line) {
            super(line);
        }
    }
}

