/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.music.player;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.lolicode.nekomusiccli.libs.flac.decode.ByteArrayFlacInput;
import org.lolicode.nekomusiccli.libs.flac.decode.DataFormatException;
import org.lolicode.nekomusiccli.music.player.Decoder;
import org.lolicode.nekomusiccli.music.player.flac.BufferedInputStreamFlacInput;

public class FlacDecoder
extends org.lolicode.nekomusiccli.libs.flac.decode.FlacDecoder
implements Decoder {
    private volatile boolean metadataRead = false;
    private volatile boolean closed = false;
    private int sampleRate = 0;
    private int channels = 0;
    private int maxBlockSize = 0;

    public FlacDecoder(InputStream in) throws IOException, DataFormatException {
        Objects.requireNonNull(in);
        this.input = in instanceof BufferedInputStream ? new BufferedInputStreamFlacInput((BufferedInputStream)in) : new ByteArrayFlacInput(in.readAllBytes());
        if (this.input.readUint(32) != 1716281667) {
            throw new DataFormatException("Invalid magic string");
        }
        this.metadataEndPos = -1L;
    }

    private synchronized void handleMetadata() throws IOException {
        if (this.metadataRead) {
            return;
        }
        while (super.readAndHandleMetadataBlock() != null) {
        }
        this.metadataRead = true;
        this.sampleRate = this.streamInfo.sampleRate;
        this.channels = this.streamInfo.numChannels;
        this.maxBlockSize = this.streamInfo.maxBlockSize;
    }

    @Override
    public int getOutputFrequency() throws IOException {
        if (!this.metadataRead) {
            this.handleMetadata();
        }
        return this.sampleRate;
    }

    @Override
    public int getOutputChannels() throws IOException {
        if (!this.metadataRead) {
            this.handleMetadata();
        }
        return this.channels;
    }

    public int getOutputMaxBlockSize() throws IOException {
        if (!this.metadataRead) {
            this.handleMetadata();
        }
        return this.maxBlockSize;
    }

    @Override
    public synchronized ByteBuffer decodeFrame() throws Exception {
        if (this.closed) {
            return null;
        }
        if (!this.metadataRead) {
            this.handleMetadata();
        }
        int[][] samples = new int[this.streamInfo.numChannels][this.streamInfo.maxBlockSize];
        byte[] sampleBytes = new byte[this.streamInfo.maxBlockSize * this.streamInfo.numChannels * this.streamInfo.sampleDepth / 8];
        int blockSamples = this.readAudioBlock(samples, 0);
        int sampleBytesLen = 0;
        for (int i = 0; i < blockSamples; ++i) {
            for (int ch = 0; ch < this.streamInfo.numChannels; ++ch) {
                int val = samples[ch][i];
                if (this.streamInfo.sampleDepth == 24) {
                    float temp = (float)val / 1.6777216E7f;
                    val = (int)(temp * 32767.0f);
                } else if (this.streamInfo.sampleDepth == 32) {
                    float temp = (float)val / 1.0995116E12f;
                    val = (int)(temp * 32767.0f);
                }
                int j = 0;
                while (j < 2) {
                    sampleBytes[sampleBytesLen] = (byte)(val >>> (j << 3));
                    ++j;
                    ++sampleBytesLen;
                }
            }
        }
        return Decoder.getByteBuffer(sampleBytes, 0, sampleBytesLen);
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        if (this.closed) {
            return;
        }
        super.seekAndReadAudioBlock(pos * (long)this.getOutputFrequency(), new int[this.getOutputChannels()][this.getOutputMaxBlockSize()], 0);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.closed = true;
    }
}

