/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.network;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class ResponseInterceptor
implements Interceptor {
    private final long MAX_SIZE;

    public ResponseInterceptor(long maxSize) {
        this.MAX_SIZE = maxSize;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response originalResponse = chain.proceed(chain.request());
        ResponseBody originalBody = originalResponse.body();
        if (originalBody != null) {
            long contentLength = originalBody.contentLength();
            if (this.MAX_SIZE > 0L && contentLength > this.MAX_SIZE) {
                originalBody.close();
                throw new IOException("Response size too large: " + contentLength + " bytes");
            }
        }
        return originalResponse;
    }
}

