/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.events;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.resources.Identifier;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.util.Lazy;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.config.ModConfig;
import org.lolicode.nekomusiccli.packet.ClientByeSender;
import org.lolicode.nekomusiccli.packet.ClientHelloSender;
import org.lolicode.nekomusiccli.utils.Alert;
import org.lolicode.nekomusiccli.utils.InstanceLock;

@EventBusSubscriber(modid="nekomusiccli", value={Dist.CLIENT})
public class KeyboardEvent
implements IModBusEvent {
    private static final KeyMapping.Category CATEGORY = KeyMapping.Category.register((Identifier)Identifier.fromNamespaceAndPath((String)"nekomusic", (String)"general"));
    public static final Lazy<KeyMapping> GLOBAL_DISABLE_KEY = Lazy.of(() -> new KeyMapping("key.nekomusic.disable", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 296, CATEGORY));
    public static final Lazy<KeyMapping> SERVER_DISABLE_KEY = Lazy.of(() -> new KeyMapping("key.nekomusic.server_disable", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 297, CATEGORY));
    public static final Lazy<KeyMapping> CLIENT_BAN_KEY = Lazy.of(() -> new KeyMapping("key.nekomusic.ban_song", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 298, CATEGORY));

    private static ModConfig getConfig() {
        return NekoMusicClient.config;
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)GLOBAL_DISABLE_KEY.get());
        event.register((KeyMapping)SERVER_DISABLE_KEY.get());
        event.register((KeyMapping)CLIENT_BAN_KEY.get());
    }

    private static void onGlobalDisablePressed(Minecraft client) {
        if (client.player == null) {
            return;
        }
        if (!KeyboardEvent.getConfig().enabled) {
            KeyboardEvent.getConfig().enabled = true;
            Alert.info("nekomusic.enable");
            ServerData server = client.getCurrentServer();
            if (server != null && !KeyboardEvent.getConfig().bannedServers.contains(server.ip)) {
                ClientHelloSender.send(client);
            }
        } else {
            KeyboardEvent.getConfig().enabled = false;
            if (NekoMusicClient.musicManager != null) {
                NekoMusicClient.musicManager.stop();
            }
            Alert.info("nekomusic.disable");
            ServerData server = client.getCurrentServer();
            if (server != null) {
                ClientByeSender.send(client);
            }
            InstanceLock.release();
        }
        KeyboardEvent.getConfig().save();
    }

    private static void onServerDisablePressed(Minecraft client) {
        if (client.player == null) {
            return;
        }
        ServerData info = client.getCurrentServer();
        if (info == null) {
            Alert.error("nekomusic.not_multiplayer");
            return;
        }
        if (KeyboardEvent.getConfig().bannedServers.contains(info.ip)) {
            KeyboardEvent.getConfig().bannedServers.remove(info.ip);
            Alert.info("nekomusic.server_enable");
            ClientHelloSender.send(client);
        } else {
            KeyboardEvent.getConfig().bannedServers.add(info.ip);
            if (NekoMusicClient.musicManager != null) {
                NekoMusicClient.musicManager.stop();
            }
            Alert.info("nekomusic.server_disable");
            ClientByeSender.send(client);
            InstanceLock.release();
        }
        KeyboardEvent.getConfig().save();
    }

    private static void onClientBanPressed(Minecraft client) {
        if (NekoMusicClient.musicManager.currentMusic == null) {
            Alert.error("player.nekomusic.not_playing");
            return;
        }
        if (KeyboardEvent.getConfig().bannedSongs.stream().anyMatch(banned -> banned.id == NekoMusicClient.musicManager.currentMusic.id)) {
            NekoMusicClient.LOGGER.error("Song is already banned: {} ({}), something went wrong?", (Object)NekoMusicClient.musicManager.currentMusic.name, (Object)NekoMusicClient.musicManager.currentMusic.id);
            Alert.error("song.nekomusic.already_banned");
        } else {
            KeyboardEvent.getConfig().bannedSongs.add(new ModConfig.BannedSong(NekoMusicClient.musicManager.currentMusic.id, NekoMusicClient.musicManager.currentMusic.name));
            Alert.info("song.nekomusic.banned", NekoMusicClient.musicManager.currentMusic.name, NekoMusicClient.musicManager.currentMusic.id);
        }
        NekoMusicClient.musicManager.stop();
        KeyboardEvent.getConfig().save();
    }

    @EventBusSubscriber(modid="nekomusiccli", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            while (((KeyMapping)GLOBAL_DISABLE_KEY.get()).consumeClick()) {
                KeyboardEvent.onGlobalDisablePressed(Minecraft.getInstance());
            }
            while (((KeyMapping)SERVER_DISABLE_KEY.get()).consumeClick()) {
                KeyboardEvent.onServerDisablePressed(Minecraft.getInstance());
            }
            while (((KeyMapping)CLIENT_BAN_KEY.get()).consumeClick()) {
                KeyboardEvent.onClientBanPressed(Minecraft.getInstance());
            }
        }
    }
}

