/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.hud;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.Identifier;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.hud.ImgFormatException;
import org.lolicode.nekomusiccli.hud.ImgSizeException;
import org.lolicode.nekomusiccli.hud.RenderMain;
import org.lwjgl.BufferUtils;

public class ImgRender {
    private static final TextureManager textureManager = Minecraft.getInstance().getTextureManager();
    private volatile DynamicTexture texture = null;
    private Identifier textureId = null;
    private int angle = 0;
    private final long startTime = System.currentTimeMillis();
    private final boolean shouldRotate;

    public ImgRender(ByteArrayInputStream stream, boolean shouldRotate) throws IOException {
        this.InitImg(stream);
        this.shouldRotate = shouldRotate;
    }

    public ImgRender(ByteArrayInputStream stream, boolean shouldRotate, boolean noWidthCheck) throws IOException {
        this.InitImg(stream, noWidthCheck);
        this.shouldRotate = shouldRotate;
    }

    public synchronized void InitImg(ByteArrayInputStream stream) throws IOException {
        this.InitImg(stream, false);
    }

    public synchronized void InitImg(ByteArrayInputStream stream, boolean noWidthCheck) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = stream;){
            int height;
            BufferedImage bufferedImage;
            if (!noWidthCheck) {
                try (ImageInputStream iis = ImageIO.createImageInputStream(stream);){
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
                    if (!readers.hasNext()) {
                        throw new ImgFormatException("No image reader found");
                    }
                    ImageReader reader = readers.next();
                    reader.setInput(iis, true, true);
                    if (NekoMusicClient.config.imgWidthLimit > 0L && ((long)reader.getWidth(0) > NekoMusicClient.config.imgWidthLimit || (long)reader.getHeight(0) > NekoMusicClient.config.imgWidthLimit)) {
                        throw new ImgSizeException("Image too large");
                    }
                }
                stream.reset();
            }
            if ((bufferedImage = ImageIO.read(stream)) == null || bufferedImage.getWidth() == 0 || bufferedImage.getHeight() == 0) {
                throw new ImgFormatException("Failed to load image");
            }
            int width = bufferedImage.getWidth();
            if (width != (height = bufferedImage.getHeight())) {
                int min = Math.min(width, height);
                bufferedImage = bufferedImage.getSubimage((width - min) / 2, (height - min) / 2, min, min);
                width = height = min;
            }
            int[] pixels = new int[width * height];
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(width * height * 4));
            if (NekoMusicClient.config.enableHudImgRotate) {
                BufferedImage img = new BufferedImage(width, height, 2);
                Graphics2D g2d = img.createGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.drawImage(bufferedImage, (int)((double)width * 0.08), (int)((double)height * 0.08), width - (int)((double)width * 0.08) * 2, height - (int)((double)height * 0.08) * 2, null);
                Area outer = new Area(new Rectangle(0, 0, img.getWidth(), img.getHeight()));
                int x = (int)((double)width * 0.08);
                int y = (int)((double)height * 0.08);
                Ellipse2D.Double inner = new Ellipse2D.Double(x, y, width - x * 2, height - y * 2);
                outer.subtract(new Area(inner));
                g2d.setColor(Color.BLACK);
                g2d.fill(outer);
                g2d.dispose();
                BufferedImage newImg = this.createCenterCut(img, new Dimension(width, height));
                newImg.getRGB(0, 0, width, height, pixels, 0, width);
            } else {
                bufferedImage.getRGB(0, 0, width, height, pixels, 0, width);
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = pixels[y * width + x];
                    byteBuffer.put((byte)(pixel & 0xFF));
                    byteBuffer.put((byte)(pixel >> 8 & 0xFF));
                    byteBuffer.put((byte)(pixel >> 16 & 0xFF));
                    byteBuffer.put((byte)(pixel >> 24 & 0xFF));
                }
            }
            byteBuffer.flip();
            this.createTexture(width, height, byteBuffer);
        }
    }

    public synchronized void RenderImg(GuiGraphics context) {
        if (this.texture == null || this.textureId == null) {
            return;
        }
        RenderMain.drawImg(context, this.textureId, this.shouldRotate, this.angle);
        this.angle = (int)((System.currentTimeMillis() - this.startTime) / (long)NekoMusicClient.config.imgRotateSpeed) % 360;
    }

    private synchronized void DisposeImg() {
        if (this.textureId != null) {
            Minecraft.getInstance().execute(() -> textureManager.release(this.textureId));
            this.textureId = null;
        }
        this.texture = null;
    }

    public void close() {
        this.DisposeImg();
    }

    private BufferedImage createCenterCut(BufferedImage inputImage, Dimension d) {
        BufferedImage image = new BufferedImage(d.width, d.height, 6);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = (inputImage.getWidth() - d.width) / 2;
        int y = (inputImage.getHeight() - d.height) / 2;
        Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, d.width, d.height);
        g2d.setClip(shape);
        g2d.drawImage(inputImage, 0, 0, d.width, d.height, x, y, x + d.width, y + d.height, null);
        g2d.dispose();
        return image;
    }

    private synchronized void createTexture(int width, int height, ByteBuffer byteBuffer) {
        Minecraft.getInstance().execute(() -> {
            try (NativeImage img = new NativeImage(NativeImage.Format.RGBA, width, height, true);){
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int color = byteBuffer.getInt((y * width + x) * 4);
                        img.setPixel(x, y, color);
                    }
                }
                this.textureId = NekoMusicClient.MOD_BASE_IDENTIFIER.withPath("hud_img");
                this.texture = new DynamicTexture(() -> ((Identifier)this.textureId).toString(), img);
                textureManager.register(this.textureId, (AbstractTexture)this.texture);
            }
        });
    }
}

