/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.hud;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import org.joml.Matrix3x2fStack;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.config.ModConfig;

public class RenderMain {
    private static final int fontHeight;

    public static void drawText(GuiGraphics context, String text, float x, float y, int color) {
        context.drawString(Minecraft.getInstance().font, text, (int)x, (int)y, color, false);
    }

    public static void drawMultiLineText(GuiGraphics context, String text, float x, float y, int color) {
        if (text == null || text.isBlank()) {
            return;
        }
        int offset = 0;
        for (String line : text.split("\n")) {
            RenderMain.drawText(context, line, x, y + (float)offset, color);
            offset += fontHeight + 2;
        }
    }

    public static void drawImg(GuiGraphics context, Identifier textureId, boolean shouldRotate, int angle) {
        ModConfig config = NekoMusicClient.config;
        int imgSize = config.imgSize;
        int offset = imgSize / 2;
        Matrix3x2fStack matrices = context.pose();
        matrices.pushMatrix();
        matrices.translate((float)(config.imgX + offset), (float)(config.imgY + offset));
        if (shouldRotate) {
            matrices.rotate((float)angle * ((float)Math.PI / 180));
        }
        context.blit(RenderPipelines.GUI_TEXTURED, textureId, -offset, -offset, (float)imgSize, (float)imgSize, imgSize, imgSize, imgSize, imgSize);
        matrices.popMatrix();
    }

    static {
        Objects.requireNonNull(Minecraft.getInstance().font);
        fontHeight = 9;
    }
}

