/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.integration.plasmovoice;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.config.ModConfig;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.AddonLoaderScope;
import su.plo.voice.api.addon.InjectPlasmoVoice;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.source.LoopbackSource;

@Addon(id="nekomusiccli", name="NekoMusic Client Integration", version="1.0.0", authors={"KoishiMoe"}, scope=AddonLoaderScope.CLIENT)
public final class NekoMusicPVAddon
implements AddonInitializer {
    @InjectPlasmoVoice
    private PlasmoVoiceClient client;
    private ScheduledExecutorService scheduler = null;
    private volatile float volume = 1.0f;
    private volatile boolean anyCanHear = false;

    public void onAddonInitialize() {
        NekoMusicClient.pvAddon = this;
    }

    public void onAddonShutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    void onJoinWorld(Minecraft client) {
        if (client.isSingleplayer()) {
            return;
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("NekoMusic Client PlasmoVoice Integration").build());
        this.scheduler.scheduleWithFixedDelay(() -> {
            this.anyCanHear = this.client.getSourceManager().getSources().stream().anyMatch(source -> !(source instanceof LoopbackSource) && source.canHear());
            this.setMusicVolume();
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    void onLeaveWorld() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
            this.anyCanHear = false;
            this.setMusicVolume();
        }
    }

    public float getVolume() {
        ModConfig config = NekoMusicClient.config;
        return this.anyCanHear ? (config.useAbsoluteVolume ? 1.0f : this.volume) * (float)config.volumeWhenPlayingVoice / 100.0f : this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
        this.setMusicVolume();
    }

    public void setMusicVolume() {
        NekoMusicClient.musicManager.setVolume(this.getVolume());
    }
}

