/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.decode;

import java.io.IOException;
import java.util.Objects;
import org.lolicode.nekomusiccli.libs.flac.decode.AbstractFlacLowLevelInput;

public final class ByteArrayFlacInput
extends AbstractFlacLowLevelInput {
    private byte[] data;
    private int offset;

    public ByteArrayFlacInput(byte[] b) {
        this.data = Objects.requireNonNull(b);
        this.offset = 0;
    }

    @Override
    public long getLength() {
        return this.data.length;
    }

    @Override
    public void seekTo(long pos) {
        this.offset = (int)pos;
        this.positionChanged(pos);
    }

    @Override
    protected int readUnderlying(byte[] buf, int off, int len) {
        if (off < 0 || off > buf.length || len < 0 || len > buf.length - off) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = Math.min(this.data.length - this.offset, len);
        if (n == 0) {
            return -1;
        }
        System.arraycopy(this.data, this.offset, buf, off, n);
        this.offset += n;
        return n;
    }

    @Override
    public void close() throws IOException {
        if (this.data != null) {
            this.data = null;
            super.close();
        }
    }
}

