/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public final class BitOutputStream
implements AutoCloseable {
    private OutputStream out;
    private long bitBuffer;
    private int bitBufferLen;
    private long byteCount;
    private int crc8;
    private int crc16;

    public BitOutputStream(OutputStream out) throws IOException {
        this.out = Objects.requireNonNull(out);
        this.bitBuffer = 0L;
        this.bitBufferLen = 0;
        this.byteCount = 0L;
        this.resetCrcs();
    }

    public void alignToByte() throws IOException {
        this.writeInt((64 - this.bitBufferLen) % 8, 0);
    }

    private void checkByteAligned() {
        if (this.bitBufferLen % 8 != 0) {
            throw new IllegalStateException("Not at a byte boundary");
        }
    }

    public void writeInt(int n, int val) throws IOException {
        if (n < 0 || n > 32) {
            throw new IllegalArgumentException();
        }
        if (this.bitBufferLen + n > 64) {
            this.flush();
            assert (this.bitBufferLen + n <= 64);
        }
        this.bitBuffer <<= n;
        this.bitBuffer |= (long)val & (1L << n) - 1L;
        this.bitBufferLen += n;
        assert (0 <= this.bitBufferLen && this.bitBufferLen <= 64);
    }

    public void flush() throws IOException {
        while (this.bitBufferLen >= 8) {
            this.bitBufferLen -= 8;
            int b = (int)(this.bitBuffer >>> this.bitBufferLen) & 0xFF;
            this.out.write(b);
            ++this.byteCount;
            this.crc8 ^= b;
            this.crc16 ^= b << 8;
            for (int i = 0; i < 8; ++i) {
                this.crc8 <<= 1;
                this.crc16 <<= 1;
                this.crc8 ^= (this.crc8 >>> 8) * 263;
                this.crc16 ^= (this.crc16 >>> 16) * 98309;
                assert (this.crc8 >>> 8 == 0);
                assert (this.crc16 >>> 16 == 0);
            }
        }
        assert (0 <= this.bitBufferLen && this.bitBufferLen <= 64);
        this.out.flush();
    }

    public void resetCrcs() throws IOException {
        this.flush();
        this.crc8 = 0;
        this.crc16 = 0;
    }

    public int getCrc8() throws IOException {
        this.checkByteAligned();
        this.flush();
        if (this.crc8 >>> 8 != 0) {
            throw new AssertionError();
        }
        return this.crc8;
    }

    public int getCrc16() throws IOException {
        this.checkByteAligned();
        this.flush();
        if (this.crc16 >>> 16 != 0) {
            throw new AssertionError();
        }
        return this.crc16;
    }

    public long getByteCount() {
        return this.byteCount + (long)(this.bitBufferLen / 8);
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.checkByteAligned();
            this.flush();
            this.out.close();
            this.out = null;
        }
    }
}

