/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.io.IOException;
import java.util.Objects;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;
import org.lolicode.nekomusiccli.libs.flac.encode.LinearPredictiveEncoder;
import org.lolicode.nekomusiccli.libs.flac.encode.RiceEncoder;
import org.lolicode.nekomusiccli.libs.flac.encode.SizeEstimate;
import org.lolicode.nekomusiccli.libs.flac.encode.SubframeEncoder;

final class FixedPredictionEncoder
extends SubframeEncoder {
    private final int order;
    public int riceOrder;
    private static final int[][] COEFFICIENTS = new int[][]{new int[0], {1}, {2, -1}, {3, -3, 1}, {4, -6, 4, -1}};

    public static SizeEstimate<SubframeEncoder> computeBest(long[] samples, int shift, int depth, int order, int maxRiceOrder) {
        FixedPredictionEncoder enc = new FixedPredictionEncoder(samples, shift, depth, order);
        samples = LinearPredictiveEncoder.shiftRight(samples, shift);
        LinearPredictiveEncoder.applyLpc(samples, COEFFICIENTS[order], 0);
        long temp = RiceEncoder.computeBestSizeAndOrder(samples, order, maxRiceOrder);
        enc.riceOrder = (int)(temp & 0xFL);
        long size = (long)(8 + shift + order * depth) + (temp >>> 4);
        return new SizeEstimate<SubframeEncoder>(size, enc);
    }

    public FixedPredictionEncoder(long[] samples, int shift, int depth, int order) {
        super(shift, depth);
        if (order < 0 || order >= COEFFICIENTS.length || samples.length < order) {
            throw new IllegalArgumentException();
        }
        this.order = order;
    }

    @Override
    public void encode(long[] samples, BitOutputStream out) throws IOException {
        Objects.requireNonNull(samples);
        Objects.requireNonNull(out);
        if (samples.length < this.order) {
            throw new IllegalArgumentException();
        }
        this.writeTypeAndShift(8 + this.order, out);
        samples = LinearPredictiveEncoder.shiftRight(samples, this.sampleShift);
        for (int i = 0; i < this.order; ++i) {
            this.writeRawSample(samples[i], out);
        }
        LinearPredictiveEncoder.applyLpc(samples, COEFFICIENTS[this.order], 0);
        RiceEncoder.encode(samples, this.order, this.riceOrder, out);
    }
}

