/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.io.IOException;
import java.util.Objects;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;
import org.lolicode.nekomusiccli.libs.flac.encode.ConstantEncoder;
import org.lolicode.nekomusiccli.libs.flac.encode.FastDotProduct;
import org.lolicode.nekomusiccli.libs.flac.encode.FixedPredictionEncoder;
import org.lolicode.nekomusiccli.libs.flac.encode.LinearPredictiveEncoder;
import org.lolicode.nekomusiccli.libs.flac.encode.SizeEstimate;
import org.lolicode.nekomusiccli.libs.flac.encode.VerbatimEncoder;

public abstract class SubframeEncoder {
    protected final int sampleShift;
    protected final int sampleDepth;

    public static SizeEstimate<SubframeEncoder> computeBest(long[] samples, int sampleDepth, SearchOptions opt) {
        Objects.requireNonNull(samples);
        if (sampleDepth < 1 || sampleDepth > 33) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(opt);
        for (long x : samples) {
            if ((x >>= sampleDepth - 1) == 0L || x == -1L) continue;
            throw new IllegalArgumentException();
        }
        SizeEstimate<SubframeEncoder> result = ConstantEncoder.computeBest(samples, 0, sampleDepth);
        if (result != null) {
            return result;
        }
        int shift = SubframeEncoder.computeWastedBits(samples);
        result = VerbatimEncoder.computeBest(samples, shift, sampleDepth);
        for (int order = opt.minFixedOrder; 0 <= order && order <= opt.maxFixedOrder; ++order) {
            SizeEstimate<SubframeEncoder> temp = FixedPredictionEncoder.computeBest(samples, shift, sampleDepth, order, opt.maxRiceOrder);
            result = result.minimum(temp);
        }
        FastDotProduct fdp = new FastDotProduct(samples, Math.max(opt.maxLpcOrder, 0));
        for (int order = opt.minLpcOrder; 0 <= order && order <= opt.maxLpcOrder; ++order) {
            SizeEstimate<SubframeEncoder> temp = LinearPredictiveEncoder.computeBest(samples, shift, sampleDepth, order, Math.min(opt.lpcRoundVariables, order), fdp, opt.maxRiceOrder);
            result = result.minimum(temp);
        }
        return result;
    }

    private static int computeWastedBits(long[] data) {
        Objects.requireNonNull(data);
        long accumulator = 0L;
        for (long x : data) {
            accumulator |= x;
        }
        if (accumulator == 0L) {
            return 0;
        }
        int result = Long.numberOfTrailingZeros(accumulator);
        assert (0 <= result && result <= 63);
        return result;
    }

    protected SubframeEncoder(int shift, int depth) {
        if (depth < 1 || depth > 33 || shift < 0 || shift > depth) {
            throw new IllegalArgumentException();
        }
        this.sampleShift = shift;
        this.sampleDepth = depth;
    }

    public abstract void encode(long[] var1, BitOutputStream var2) throws IOException;

    protected final void writeTypeAndShift(int type, BitOutputStream out) throws IOException {
        if (type >>> 6 != 0) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(out);
        out.writeInt(1, 0);
        out.writeInt(6, type);
        if (this.sampleShift == 0) {
            out.writeInt(1, 0);
        } else {
            out.writeInt(1, 1);
            for (int i = 0; i < this.sampleShift - 1; ++i) {
                out.writeInt(1, 0);
            }
            out.writeInt(1, 1);
        }
    }

    protected final void writeRawSample(long val, BitOutputStream out) throws IOException {
        int width = this.sampleDepth - this.sampleShift;
        if (width < 1 || width > 33) {
            throw new IllegalStateException();
        }
        long temp = val >> width - 1;
        if (temp != 0L && temp != -1L) {
            throw new IllegalArgumentException();
        }
        if (width <= 32) {
            out.writeInt(width, (int)val);
        } else {
            out.writeInt(1, (int)(val >>> 32));
            out.writeInt(32, (int)val);
        }
    }

    public static final class SearchOptions {
        public final int minFixedOrder;
        public final int maxFixedOrder;
        public final int minLpcOrder;
        public final int maxLpcOrder;
        public final int lpcRoundVariables;
        public final int maxRiceOrder;
        public static final SearchOptions SUBSET_ONLY_FIXED = new SearchOptions(0, 4, -1, -1, 0, 8);
        public static final SearchOptions SUBSET_MEDIUM = new SearchOptions(0, 1, 2, 8, 0, 5);
        public static final SearchOptions SUBSET_BEST = new SearchOptions(0, 1, 2, 12, 0, 8);
        public static final SearchOptions SUBSET_INSANE = new SearchOptions(0, 4, 1, 12, 4, 8);
        public static final SearchOptions LAX_MEDIUM = new SearchOptions(0, 1, 2, 22, 0, 15);
        public static final SearchOptions LAX_BEST = new SearchOptions(0, 1, 2, 32, 0, 15);
        public static final SearchOptions LAX_INSANE = new SearchOptions(0, 1, 2, 32, 4, 15);

        public SearchOptions(int minFixedOrder, int maxFixedOrder, int minLpcOrder, int maxLpcOrder, int lpcRoundVars, int maxRiceOrder) {
            if (!(minFixedOrder == -1 && maxFixedOrder == -1 || 0 <= minFixedOrder && minFixedOrder <= maxFixedOrder && maxFixedOrder <= 4)) {
                throw new IllegalArgumentException();
            }
            if (!(minLpcOrder == -1 && maxLpcOrder == -1 || 1 <= minLpcOrder && minLpcOrder <= maxLpcOrder && maxLpcOrder <= 32)) {
                throw new IllegalArgumentException();
            }
            if (lpcRoundVars < 0 || lpcRoundVars > 30) {
                throw new IllegalArgumentException();
            }
            if (maxRiceOrder < 0 || maxRiceOrder > 15) {
                throw new IllegalArgumentException();
            }
            this.minFixedOrder = minFixedOrder;
            this.maxFixedOrder = maxFixedOrder;
            this.minLpcOrder = minLpcOrder;
            this.maxLpcOrder = maxLpcOrder;
            this.lpcRoundVariables = lpcRoundVars;
            this.maxRiceOrder = maxRiceOrder;
        }
    }
}

