/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.music.player;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import okhttp3.Response;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.music.MusicManager;
import org.lolicode.nekomusiccli.music.MusicObj;
import org.lolicode.nekomusiccli.music.player.ByteArrayInputStreamAudioPlayer;
import org.lolicode.nekomusiccli.music.player.Decoder;
import org.lolicode.nekomusiccli.music.player.ResponseAudioPlayer;
import org.lolicode.nekomusiccli.network.DomainNotInWhitelistException;
import org.lolicode.nekomusiccli.utils.Alert;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public abstract class AudioPlayer
implements AutoCloseable {
    protected final int source;
    protected Decoder decoder = null;
    private final BlockingQueue<IntBuffer> queue = new LinkedBlockingQueue<IntBuffer>();
    private Thread decodeThread = null;
    private Thread playbackThread = null;
    private volatile boolean playbackRunning = false;
    protected volatile boolean cleanupDone = false;

    public static AudioPlayer getAudioPlayerStream(MusicObj music) throws InterruptedIOException {
        if (music == null || music.url == null || music.url.isBlank()) {
            throw new IllegalArgumentException("MusicObj is null or url is null or blank");
        }
        String urlWithoutParam = music.url.split("\\?")[0].toLowerCase();
        if (!urlWithoutParam.endsWith(".mp3") && !urlWithoutParam.endsWith(".flac")) {
            return null;
        }
        if (music.seekTo > 0L && urlWithoutParam.endsWith(".flac")) {
            NekoMusicClient.LOGGER.info("Seeking is not supported while streaming flac audio");
            return null;
        }
        Response response = null;
        try {
            response = NekoMusicClient.netUtils.getMusicResponse(music);
            if (response == null) {
                return null;
            }
            assert (response.body() != null);
            return ResponseAudioPlayer.getMp3OrFlacAudioPlayer(response, urlWithoutParam.endsWith(".mp3"));
        }
        catch (DomainNotInWhitelistException e) {
            NekoMusicClient.LOGGER.error("Domain not in whitelist: {}", (Object)music.url, (Object)e);
            Alert.error("player.nekomusic.domain_not_in_whitelist");
        }
        catch (InterruptedIOException e) {
            if (response != null) {
                response.close();
            }
            throw e;
        }
        catch (Exception e) {
            if (response != null) {
                response.close();
            }
            NekoMusicClient.LOGGER.error("Failed to get music stream", (Throwable)e);
            Alert.error("player.nekomusic.stream.failed");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AudioPlayer getAudioPlayerNoStream(MusicObj music) throws InterruptedIOException {
        if (music == null) throw new IllegalArgumentException("MusicObj is null or url is null or blank");
        if (music.url == null) throw new IllegalArgumentException("MusicObj is null or url is null or blank");
        if (music.url.isBlank()) {
            throw new IllegalArgumentException("MusicObj is null or url is null or blank");
        }
        try (Response resp = NekoMusicClient.netUtils.getMusicResponse(music);){
            if (resp == null || resp.body() == null) {
                AudioPlayer audioPlayer = null;
                return audioPlayer;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(resp.body().bytes());
            ByteArrayInputStreamAudioPlayer byteArrayInputStreamAudioPlayer = new ByteArrayInputStreamAudioPlayer(stream);
            return byteArrayInputStreamAudioPlayer;
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (Exception e) {
            NekoMusicClient.LOGGER.error("Failed to get music bytes", (Throwable)e);
            Alert.error("player.nekomusic.stream.failed");
            return null;
        }
    }

    public AudioPlayer() {
        this.source = AL10.alGenSources();
    }

    public synchronized void play() {
        if (this.playbackRunning) {
            return;
        }
        this.playbackRunning = true;
        this.decodeThread = new Thread(this::decodeLoop, "NekoMusic Client Audio-Decode-Loop");
        this.decodeThread.start();
        this.playbackThread = new Thread(this::playBackLoop, "NekoMusic Client Audio-Playback-Loop");
        this.playbackThread.start();
    }

    public synchronized void playFrom(long pos) throws IOException {
        if (this.playbackRunning) {
            return;
        }
        assert (this.decoder != null);
        assert (pos >= 0L);
        try {
            if (pos > 0L) {
                this.decoder.seek(pos);
            }
            this.play();
        }
        catch (IOException e) {
            NekoMusicClient.LOGGER.error("Failed to seek to position", (Throwable)e);
            Alert.error("player.nekomusic.seek.failed");
            throw e;
        }
    }

    public synchronized void stop() {
        try {
            if (this.decoder != null) {
                this.decoder.close();
            }
        }
        catch (Exception e) {
            NekoMusicClient.LOGGER.error("Failed to close the decoder", (Throwable)e);
        }
        this.playbackRunning = false;
        if (this.decodeThread != null) {
            this.decodeThread.interrupt();
        }
        if (this.playbackThread != null) {
            this.playbackThread.interrupt();
        }
    }

    public synchronized void cleanup() {
        if (this.cleanupDone) {
            return;
        }
        this.stop();
        AL10.alSourceStop((int)this.source);
        AL10.alSourceUnqueueBuffers((int)this.source);
        AL10.alDeleteSources((int)this.source);
        this.queue.forEach(AL10::alDeleteBuffers);
        this.cleanupDone = true;
    }

    private void decodeLoop() {
        try {
            while (this.playbackRunning) {
                ByteBuffer buffer = this.decoder.decodeFrame();
                if (buffer == null) {
                    break;
                }
                IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
                AL10.alGenBuffers((IntBuffer)intBuffer);
                AL10.alBufferData((int)intBuffer.get(0), (int)(this.decoder.getOutputChannels() == 1 ? 4353 : 4355), (ByteBuffer)buffer, (int)this.decoder.getOutputFrequency());
                AL10.alSourcef((int)this.source, (int)4106, (float)MusicManager.getVolume());
                this.queue.put(intBuffer);
            }
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            NekoMusicClient.LOGGER.error("Failed to decode the audio stream", (Throwable)e);
            Alert.error("player.nekomusic.decode.failed");
        }
        finally {
            try {
                this.decoder.close();
            }
            catch (Exception e) {
                NekoMusicClient.LOGGER.error("Failed to close the decoder", (Throwable)e);
            }
        }
    }

    private void playBackLoop() {
        try {
            while (this.playbackRunning) {
                IntBuffer buffer = this.queue.take();
                AL10.alSourceQueueBuffers((int)this.source, (IntBuffer)buffer);
                if (AL10.alGetSourcei((int)this.source, (int)4112) == 4114) continue;
                AL10.alSourcePlay((int)this.source);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.cleanup();
        }
    }

    public void setGain(float volume) throws IllegalStateException, IllegalArgumentException {
        if (volume < 0.0f || volume > 1.0f) {
            throw new IllegalArgumentException("Volume not valid: " + volume);
        }
        if (this.cleanupDone) {
            throw new IllegalStateException("Cannot set gain after cleanup");
        }
        AL10.alSourcef((int)this.source, (int)4106, (float)volume);
    }

    @Override
    public void close() throws Exception {
        this.cleanup();
    }
}

