/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.music.player;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javazoom.jl.decoder.BitstreamException;
import org.apache.tika.Tika;
import org.jetbrains.annotations.Nullable;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.libs.flac.decode.DataFormatException;
import org.lolicode.nekomusiccli.music.player.FlacDecoder;
import org.lolicode.nekomusiccli.music.player.Mp3Decoder;
import org.lolicode.nekomusiccli.music.player.OggDecoder;
import org.lwjgl.BufferUtils;

public interface Decoder
extends AutoCloseable {
    public static final Tika tika = new Tika();

    public static Decoder getDecoder(ByteArrayInputStream inputStream) throws DataFormatException, IOException, BitstreamException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        String mimeType = tika.detect((InputStream)inputStream);
        inputStream.reset();
        switch (mimeType) {
            case "audio/mpeg": {
                return Decoder.getMp3Decoder(inputStream);
            }
            case "audio/flac": 
            case "audio/x-flac": {
                return Decoder.getFlacDecoder(inputStream);
            }
            case "audio/ogg": 
            case "audio/vorbis": {
                return Decoder.getOggDecoder(inputStream);
            }
        }
        NekoMusicClient.LOGGER.warn("Unknown mime type: " + mimeType + ", decoder may not work properly");
        try {
            return Decoder.getFlacDecoder(inputStream);
        }
        catch (DataFormatException e) {
            try {
                inputStream.reset();
                return Decoder.getOggDecoder(inputStream);
            }
            catch (IOException | DataFormatException ex) {
                inputStream.reset();
                return Decoder.getMp3Decoder(inputStream);
            }
        }
    }

    public static Decoder getMp3Decoder(InputStream inputStream) throws DataFormatException, BitstreamException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        return new Mp3Decoder(inputStream);
    }

    public static Decoder getFlacDecoder(InputStream inputStream) throws DataFormatException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        return new FlacDecoder(inputStream);
    }

    public static Decoder getOggDecoder(ByteArrayInputStream inputStream) throws DataFormatException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        return new OggDecoder(inputStream);
    }

    public static ByteBuffer getByteBuffer(byte[] bytes) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)bytes.length);
        byteBuffer.put(bytes, 0, bytes.length);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static ByteBuffer getByteBuffer(byte[] bytes, int offset, int length) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)length);
        byteBuffer.put(bytes, offset, length);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static ByteBuffer getByteBuffer(short[] shorts) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(shorts.length * 2));
        for (short s : shorts) {
            byteBuffer.putShort(s);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public int getOutputFrequency() throws IOException;

    public int getOutputChannels() throws IOException;

    public void seek(long var1) throws IOException;

    @Override
    public void close() throws Exception;

    @Nullable
    public ByteBuffer decodeFrame() throws Exception;
}

