/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.music.player;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lolicode.nekomusiccli.music.player.Decoder;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisInfo;

public class OggDecoder
implements Decoder {
    private final long decoder;
    private volatile boolean closed = false;
    private final STBVorbisInfo info;

    public OggDecoder(ByteArrayInputStream inputStream) throws IOException {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)inputStream.available());
        byteBuffer.put(inputStream.readAllBytes());
        byteBuffer.flip();
        IntBuffer errorBuffer = BufferUtils.createIntBuffer((int)1);
        this.decoder = STBVorbis.stb_vorbis_open_memory((ByteBuffer)byteBuffer, (IntBuffer)errorBuffer, null);
        if (this.decoder == 0L || errorBuffer.get(0) != 0) {
            throw new IOException("Failed to open Ogg file: " + errorBuffer.get(0));
        }
        try (STBVorbisInfo info = STBVorbisInfo.malloc();){
            STBVorbis.stb_vorbis_get_info((long)this.decoder, (STBVorbisInfo)info);
            this.info = info;
        }
    }

    @Override
    public int getOutputFrequency() {
        return this.info.sample_rate();
    }

    @Override
    public int getOutputChannels() {
        return this.info.channels();
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        if (this.closed) {
            return;
        }
        int samplePos = (int)pos * this.info.sample_rate();
        boolean success = STBVorbis.stb_vorbis_seek_frame((long)this.decoder, (int)samplePos);
        if (!success) {
            throw new IOException("Failed to seek to position: " + pos);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        STBVorbis.stb_vorbis_close((long)this.decoder);
    }

    @Override
    public synchronized ByteBuffer decodeFrame() {
        if (this.closed) {
            return null;
        }
        try (STBVorbisInfo info = STBVorbisInfo.malloc();){
            STBVorbis.stb_vorbis_get_info((long)this.decoder, (STBVorbisInfo)info);
            int channels = info.channels();
            int length = STBVorbis.stb_vorbis_stream_length_in_samples((long)this.decoder);
            short[] shorts = new short[length * channels];
            int samples = STBVorbis.stb_vorbis_get_samples_short_interleaved((long)this.decoder, (int)channels, (short[])shorts);
            if (samples == 0) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = Decoder.getByteBuffer(shorts);
            return byteBuffer;
        }
    }
}

