/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.network;

import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.config.ModConfig;
import org.lolicode.nekomusiccli.music.AlbumObj;
import org.lolicode.nekomusiccli.music.MusicObj;
import org.lolicode.nekomusiccli.network.DomainNotInWhitelistException;
import org.lolicode.nekomusiccli.network.NetRequest;
import org.lolicode.nekomusiccli.network.ResponseInterceptor;

public class NetUtils {
    private final OkHttpClient musicClient;
    private final OkHttpClient imageClient;

    public NetUtils(ModConfig config) {
        this.musicClient = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)new ResponseInterceptor(config.musicResponseSizeLimit * 1024L * 1024L)).cache(NekoMusicClient.cacheUtils.getMusicCache()).build();
        this.imageClient = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).addInterceptor((Interceptor)new ResponseInterceptor(config.imgResponseSizeLimit * 1024L * 1024L)).cache(NekoMusicClient.cacheUtils.getImgCache()).build();
    }

    public Response getMusicResponse(MusicObj musicObj) throws InterruptedIOException {
        Response response = null;
        String cachedUrl = NekoMusicClient.cacheUtils.queryMusicCache(musicObj.Hash());
        if (cachedUrl != null && !cachedUrl.isBlank()) {
            response = this.fetchData(cachedUrl, this.musicClient, true);
        }
        if (response == null) {
            NekoMusicClient.LOGGER.debug("Cache miss for " + musicObj.Hash());
            response = this.fetchData(musicObj.url, this.musicClient, false);
            NekoMusicClient.cacheUtils.updateMusicCache(musicObj.Hash(), musicObj.url);
        }
        return response;
    }

    public Response getImageResponse(AlbumObj albumObj) throws InterruptedIOException {
        Response response = null;
        String cachedUrl = NekoMusicClient.cacheUtils.queryImgCache(albumObj.Hash());
        if (cachedUrl != null && !cachedUrl.isBlank()) {
            response = this.fetchData(cachedUrl, this.imageClient, true);
        }
        if (response == null) {
            NekoMusicClient.LOGGER.debug("Cache miss for " + albumObj.Hash());
            response = this.fetchData(albumObj.picUrl, this.imageClient, false);
            NekoMusicClient.cacheUtils.updateImgCache(albumObj.Hash(), albumObj.picUrl);
        }
        return response;
    }

    private Response fetchData(String url, OkHttpClient client, boolean forceCache) throws InterruptedIOException {
        Response resp;
        if (!(forceCache || NekoMusicClient.config.domainWhitelist == null || NekoMusicClient.config.domainWhitelist.isEmpty() || this.isDomainWhitelisted(url, NekoMusicClient.config.domainWhitelist))) {
            throw new DomainNotInWhitelistException("Domain not whitelisted: " + url);
        }
        try {
            resp = client.newCall(NetRequest.getRequest(url, forceCache)).execute();
        }
        catch (InterruptedIOException e) {
            NekoMusicClient.LOGGER.info("Request interrupted");
            throw e;
        }
        catch (Exception e) {
            NekoMusicClient.LOGGER.error("Failed to get data: ", (Throwable)e);
            return null;
        }
        if (resp.code() != 200) {
            resp.close();
            return null;
        }
        ResponseBody body = resp.body();
        if (body == null || body.contentLength() <= 0L) {
            resp.close();
            return null;
        }
        return resp;
    }

    private List<String> getParentDomains(String domain) {
        ArrayList<String> domains = new ArrayList<String>();
        String[] parts = domain.split("\\.");
        for (int i = 0; i < parts.length - 1; ++i) {
            domains.add(String.join((CharSequence)".", Arrays.copyOfRange(parts, i, parts.length)));
        }
        return domains;
    }

    private boolean isDomainWhitelisted(String url, Collection<String> whitelist) {
        try {
            String host = URI.create(url).toURL().getHost();
            List<String> parentDomains = this.getParentDomains(host);
            for (String domain : parentDomains) {
                if (!whitelist.contains(domain)) continue;
                return true;
            }
            return whitelist.contains(host);
        }
        catch (MalformedURLException e) {
            NekoMusicClient.LOGGER.error("Invalid URL: ", (Throwable)e);
            return false;
        }
    }
}

