/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.packet;

import lol.bai.badpackets.api.play.PlayPackets;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.Identifier;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.music.MusicList;
import org.lolicode.nekomusiccli.music.MusicObj;
import org.lolicode.nekomusiccli.utils.Alert;

public class ServerPacketReceiver {
    private static final Identifier METADATA_PACKET_ID = NekoMusicClient.MOD_BASE_IDENTIFIER.withPath("metadata");
    private static final Identifier PLAYLIST_PACKET_ID = NekoMusicClient.MOD_BASE_IDENTIFIER.withPath("list");

    private static void onReceiveMetadata(FriendlyByteBuf buf, ClientPacketListener handler) {
        if (buf == null || !NekoMusicClient.config.enabled || NekoMusicClient.config.bannedServers.contains(handler.getServerData() == null ? "" : handler.getServerData().ip)) {
            NekoMusicClient.musicManager.stop();
            return;
        }
        MusicObj musicObj = (MusicObj)NekoMusicClient.GSON.fromJson(buf.readUtf(), MusicObj.class);
        if (musicObj == null || musicObj.url == null || musicObj.url.isEmpty()) {
            NekoMusicClient.musicManager.stop();
            return;
        }
        if (NekoMusicClient.config.bannedSongs.stream().anyMatch(banned -> banned.id == musicObj.id)) {
            NekoMusicClient.LOGGER.info("Banned song: {} ({})", (Object)musicObj.name, (Object)musicObj.id);
            Alert.info("player.nekomusic.song.banned", musicObj.name, musicObj.id);
            NekoMusicClient.musicManager.stop();
            return;
        }
        NekoMusicClient.musicManager.play(musicObj);
    }

    private static void onReceivePlaylist(FriendlyByteBuf buf, ClientPacketListener handler) {
        if (buf == null || !NekoMusicClient.config.enabled || NekoMusicClient.config.bannedServers.contains(handler.getServerData() == null ? "" : handler.getServerData().ip) || NekoMusicClient.hudUtils == null) {
            return;
        }
        MusicList musicList = (MusicList)NekoMusicClient.GSON.fromJson(buf.readUtf(), MusicList.class);
        if (musicList == null) {
            musicList = new MusicList();
        }
        NekoMusicClient.hudUtils.setList(musicList);
    }

    public static void register() {
        PlayPackets.registerClientChannel((Identifier)METADATA_PACKET_ID);
        PlayPackets.registerClientReceiver((Identifier)METADATA_PACKET_ID, (context, buf) -> ServerPacketReceiver.onReceiveMetadata(buf, context.handler()));
        PlayPackets.registerClientChannel((Identifier)PLAYLIST_PACKET_ID);
        PlayPackets.registerClientReceiver((Identifier)PLAYLIST_PACKET_ID, (context, buf) -> ServerPacketReceiver.onReceivePlaylist(buf, context.handler()));
    }
}

