/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli;

import com.google.gson.Gson;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lolicode.nekomusiccli.cache.CacheUtils;
import org.lolicode.nekomusiccli.config.ModConfig;
import org.lolicode.nekomusiccli.events.Events;
import org.lolicode.nekomusiccli.hud.HudUtils;
import org.lolicode.nekomusiccli.integration.plasmovoice.NekoMusicPVAddon;
import org.lolicode.nekomusiccli.integration.plasmovoice.PVAddonLoader;
import org.lolicode.nekomusiccli.music.MusicManager;
import org.lolicode.nekomusiccli.network.NetUtils;
import org.lolicode.nekomusiccli.packet.ClientByeSender;
import org.lolicode.nekomusiccli.packet.ClientHelloSender;
import org.lolicode.nekomusiccli.packet.ServerPacketReceiver;

public class NekoMusicClient
implements ClientModInitializer {
    public static final String MOD_ID = "nekomusiccli";
    public static final String MOD_NAME = "NekoMusic Client";
    public static final String MOD_CHANNEL = "nekomusic";
    public static final class_2960 MOD_BASE_IDENTIFIER = class_2960.method_60655((String)"nekomusic", (String)"nekomusiccli");
    public static final Logger LOGGER = LogManager.getLogger((String)"NekoMusic Client");
    public static final Gson GSON = new Gson();
    public static MusicManager musicManager;
    public static HudUtils hudUtils;
    public static CacheUtils cacheUtils;
    public static ModConfig config;
    public static NetUtils netUtils;
    public static NekoMusicPVAddon pvAddon;

    public void onInitializeClient() {
        Optional pvModContainer;
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        cacheUtils = new CacheUtils(config);
        netUtils = new NetUtils(config);
        musicManager = new MusicManager();
        hudUtils = new HudUtils();
        Events.register();
        ServerPacketReceiver.register();
        ClientHelloSender.register();
        ClientByeSender.register();
        if (NekoMusicClient.config.lowerVolumeWhenPlayingVoice && FabricLoader.getInstance().isModLoaded("plasmovoice") && (pvModContainer = FabricLoader.getInstance().getModContainer("plasmovoice")).isPresent()) {
            Version version = ((ModContainer)pvModContainer.get()).getMetadata().getVersion();
            try {
                if (version.compareTo((Object)Version.parse((String)"2.1.0")) >= 0) {
                    PVAddonLoader.load();
                } else {
                    LOGGER.warn("PlasmoVoice version is too low, PlasmoVoice integration will not be loaded.");
                }
            }
            catch (VersionParsingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        hudUtils = null;
        cacheUtils = null;
        pvAddon = null;
    }
}

