/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.hud;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_9848;
import okhttp3.Response;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.config.ModConfig;
import org.lolicode.nekomusiccli.hud.ImgFormatException;
import org.lolicode.nekomusiccli.hud.ImgRender;
import org.lolicode.nekomusiccli.hud.ImgSizeException;
import org.lolicode.nekomusiccli.hud.InfoRender;
import org.lolicode.nekomusiccli.hud.ListRender;
import org.lolicode.nekomusiccli.hud.LyricRender;
import org.lolicode.nekomusiccli.music.MusicList;
import org.lolicode.nekomusiccli.music.MusicObj;
import org.lolicode.nekomusiccli.utils.Alert;

public class HudUtils {
    private final class_310 client = class_310.method_1551();
    private volatile String info = null;
    private final ArrayList<String> list = new ArrayList();
    private volatile LyricRender lyricRender = null;
    private volatile ImgRender imgRender = null;
    private volatile boolean isClosed = false;
    private volatile boolean isStopped = false;
    private volatile long startTime = System.currentTimeMillis();

    public synchronized void setMusic(MusicObj music) throws InterruptedIOException {
        if (this.isClosed) {
            throw new IllegalStateException("Hud is closed");
        }
        this.stopCurrentMusic();
        this.info = music.name == null || music.name.isBlank() ? class_2561.method_43471((String)"hud.nekomusic.no_title").getString() : music.name;
        this.info = this.info + "\n";
        this.info = this.info + (music.ar == null || music.ar.isEmpty() ? class_2561.method_43471((String)"hud.nekomusic.no_artist").getString() : music.ar.getFirst().name);
        this.info = this.info + "\n";
        this.info = this.info + (music.album == null || music.album.name == null || music.album.name.isBlank() ? class_2561.method_43471((String)"hud.nekomusic.no_album").getString() : music.album.name);
        if (music.player != null && !music.player.isBlank()) {
            this.info = this.info + "\nby: " + music.player;
        }
        if (music.album != null && music.album.picUrl != null && !music.album.picUrl.isBlank()) {
            try (Response imageResponse = NekoMusicClient.netUtils.getImageResponse(music.album);){
                try {
                    if (imageResponse == null || imageResponse.body() == null) {
                        throw new IOException("Failed to load image");
                    }
                    ByteArrayInputStream imgStream = new ByteArrayInputStream(imageResponse.body().bytes());
                    this.imgRender = new ImgRender(imgStream, NekoMusicClient.config.enableHudImgRotate);
                }
                catch (Exception e) {
                    Optional defaultCover = class_310.method_1551().method_1478().method_14486(class_2960.method_60655((String)"nekomusiccli", (String)"texture/default_cover.png"));
                    if (defaultCover.isPresent()) {
                        this.imgRender = new ImgRender(new ByteArrayInputStream(((class_3298)defaultCover.get()).method_14482().readAllBytes()), NekoMusicClient.config.enableHudImgRotate, true);
                    }
                    throw e;
                }
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (ImgSizeException e) {
                NekoMusicClient.LOGGER.error("Failed to load image: " + music.album.picUrl, (Throwable)e);
                Alert.warn("hud.nekomusic.image_too_large");
            }
            catch (ImgFormatException e) {
                NekoMusicClient.LOGGER.error("Failed to load image: " + music.album.picUrl, (Throwable)e);
                Alert.warn("hud.nekomusic.invalid_image_format");
            }
            catch (IOException e) {
                NekoMusicClient.LOGGER.error("Failed to load image: " + music.album.picUrl, (Throwable)e);
                Alert.warn("hud.nekomusic.failed_to_load_image");
            }
            catch (Exception e) {
                NekoMusicClient.LOGGER.error("Failed to load image: ", (Throwable)e);
                Alert.warn("hud.nekomusic.failed_to_load_image");
            }
        }
        if (this.lyricRender != null) {
            this.lyricRender.stop();
        }
        this.lyricRender = music.lyric != null ? new LyricRender(music.lyric) : null;
        this.isStopped = false;
    }

    public synchronized void setList(MusicList list) {
        if (this.isClosed) {
            throw new IllegalStateException("Hud is closed");
        }
        this.startTime = System.currentTimeMillis();
        this.list.clear();
        this.list.addAll(list.toArrayList());
    }

    public void frame(class_332 context) {
        if (this.isClosed || this.isStopped || this.client.field_61504.method_72776()) {
            return;
        }
        ModConfig cfg = NekoMusicClient.config;
        if (!cfg.enableHud) {
            return;
        }
        if (cfg.enableHudImg && this.imgRender != null) {
            this.imgRender.RenderImg(context);
        }
        int textColor = class_9848.method_61324((int)cfg.textOpacity, (int)cfg.textColorRed, (int)cfg.textColorGreen, (int)cfg.textColorBlue);
        if (cfg.enableHudInfo) {
            InfoRender.render(context, this.info, textColor);
        }
        if (cfg.enableHudList) {
            ListRender.render(context, this.list, System.currentTimeMillis() - this.startTime, textColor);
        }
        if (cfg.enableHudLyric && this.lyricRender != null) {
            this.lyricRender.render(context, textColor);
        }
    }

    public synchronized void startLyric(long pos) {
        if (this.lyricRender != null) {
            this.lyricRender.start(pos);
        }
    }

    public synchronized void stopCurrentMusic() {
        if (this.lyricRender != null) {
            this.lyricRender.stop();
            this.lyricRender = null;
        }
        if (this.imgRender != null) {
            this.imgRender.close();
            this.imgRender = null;
        }
        this.info = null;
        this.isStopped = true;
    }

    public synchronized void close() {
        this.stopCurrentMusic();
        this.isClosed = true;
    }
}

