/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.hud;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_332;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.hud.RenderMain;
import org.lolicode.nekomusiccli.libs.lrcparser.Lyric;
import org.lolicode.nekomusiccli.libs.lrcparser.parser.LyricParser;
import org.lolicode.nekomusiccli.music.LyricObj;
import org.lolicode.nekomusiccli.utils.Alert;

public class LyricRender {
    private final ScheduledExecutorService lyricExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("NekoMusic Client-lyric-%d").build());
    private Lyric lyric;
    private volatile String currentSentence;

    public LyricRender(LyricObj lyric) {
        if (lyric == null || lyric.getLyric() == null) {
            this.lyric = null;
            return;
        }
        try {
            LyricParser lyricParser = LyricParser.create(new BufferedReader(new StringReader(lyric.getLyric())));
            LyricParser translationParser = lyric.getTranslation() == null ? null : LyricParser.create(new BufferedReader(new StringReader(lyric.getTranslation())));
            Lyric translation = translationParser == null ? null : new Lyric(translationParser.getTags(), translationParser.getSentences());
            this.lyric = new Lyric(lyricParser.getTags(), lyricParser.getSentences());
            this.lyric.merge(translation);
        }
        catch (Exception e) {
            this.lyric = null;
            NekoMusicClient.LOGGER.error("Failed to parse lyric: ", (Throwable)e);
            Alert.warn("hud.nekomusic.lyric.parse.failed");
        }
    }

    public void render(class_332 context, int color) {
        RenderMain.drawMultiLineText(context, this.currentSentence, NekoMusicClient.config.lyricX, NekoMusicClient.config.lyricY, color);
    }

    public synchronized boolean hasLyric() {
        return this.lyric != null;
    }

    public void start(long pos) {
        if (this.lyric == null) {
            return;
        }
        long startTime = System.currentTimeMillis() - pos * 1000L;
        this.lyricExecutor.scheduleAtFixedRate(() -> {
            long currentTime = System.currentTimeMillis() - startTime;
            if (currentTime > this.lyric.getDuration() || currentTime < 0L) {
                this.lyricExecutor.shutdownNow();
                return;
            }
            String sentence = this.lyric.findContent(currentTime);
            this.currentSentence = sentence == null ? "" : sentence;
        }, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.lyricExecutor.shutdownNow();
    }
}

