/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.util.Objects;

final class FastDotProduct {
    private long[] data;
    private double[] precomputed;

    public FastDotProduct(long[] data, int maxDelta) {
        this.data = Objects.requireNonNull(data);
        if (maxDelta < 0 || maxDelta >= data.length) {
            throw new IllegalArgumentException();
        }
        this.precomputed = new double[maxDelta + 1];
        for (int i = 0; i < this.precomputed.length; ++i) {
            double sum = 0.0;
            int j = 0;
            while (i + j < data.length) {
                sum += (double)data[j] * (double)data[i + j];
                ++j;
            }
            this.precomputed[i] = sum;
        }
    }

    public double dotProduct(int off0, int off1, int len) {
        int i;
        if (off0 > off1) {
            return this.dotProduct(off1, off0, len);
        }
        if (off0 < 0 || off1 < 0 || len < 0 || this.data.length - len < off1) {
            throw new IndexOutOfBoundsException();
        }
        assert (off0 <= off1);
        int delta = off1 - off0;
        if (delta > this.precomputed.length) {
            throw new IllegalArgumentException();
        }
        double removal = 0.0;
        for (i = 0; i < off0; ++i) {
            removal += (double)this.data[i] * (double)this.data[i + delta];
        }
        for (i = off1 + len; i < this.data.length; ++i) {
            removal += (double)this.data[i] * (double)this.data[i - delta];
        }
        return this.precomputed[delta] - removal;
    }
}

