/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.io.IOException;
import org.lolicode.nekomusiccli.libs.flac.common.StreamInfo;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;
import org.lolicode.nekomusiccli.libs.flac.encode.FrameEncoder;
import org.lolicode.nekomusiccli.libs.flac.encode.SubframeEncoder;

public final class FlacEncoder {
    public FlacEncoder(StreamInfo info, int[][] samples, int blockSize, SubframeEncoder.SearchOptions opt, BitOutputStream out) throws IOException {
        info.minBlockSize = blockSize;
        info.maxBlockSize = blockSize;
        info.minFrameSize = 0;
        info.maxFrameSize = 0;
        int i = 0;
        int pos = 0;
        while (pos < samples[0].length) {
            System.err.printf("frame=%d  position=%d  %.2f%%%n", i, pos, 100.0 * (double)pos / (double)samples[0].length);
            int n = Math.min(samples[0].length - pos, blockSize);
            long[][] subsamples = FlacEncoder.getRange(samples, pos, n);
            FrameEncoder enc = (FrameEncoder)FrameEncoder.computeBest((int)pos, (long[][])subsamples, (int)info.sampleDepth, (int)info.sampleRate, (SubframeEncoder.SearchOptions)opt).encoder;
            long startByte = out.getByteCount();
            enc.encode(subsamples, out);
            long frameSize = out.getByteCount() - startByte;
            if (frameSize < 0L || (long)((int)frameSize) != frameSize) {
                throw new AssertionError();
            }
            if (info.minFrameSize == 0 || frameSize < (long)info.minFrameSize) {
                info.minFrameSize = (int)frameSize;
            }
            if (frameSize > (long)info.maxFrameSize) {
                info.maxFrameSize = (int)frameSize;
            }
            pos += n;
            ++i;
        }
    }

    private static long[][] getRange(int[][] array, int off, int len) {
        long[][] result = new long[array.length][len];
        for (int i = 0; i < array.length; ++i) {
            int[] src = array[i];
            long[] dest = result[i];
            for (int j = 0; j < len; ++j) {
                dest[j] = src[off + j];
            }
        }
        return result;
    }
}

