/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.lolicode.nekomusiccli.libs.flac.common.FrameInfo;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;
import org.lolicode.nekomusiccli.libs.flac.encode.SizeEstimate;
import org.lolicode.nekomusiccli.libs.flac.encode.SubframeEncoder;

final class FrameEncoder {
    public FrameInfo metadata = new FrameInfo();
    private SubframeEncoder[] subEncoders;

    public static SizeEstimate<FrameEncoder> computeBest(int sampleOffset, long[][] samples, int sampleDepth, int sampleRate, SubframeEncoder.SearchOptions opt) {
        FrameEncoder enc = new FrameEncoder(sampleOffset, samples, sampleDepth, sampleRate);
        int numChannels = samples.length;
        SizeEstimate[] encoderInfo = new SizeEstimate[numChannels];
        if (numChannels != 2) {
            enc.metadata.channelAssignment = numChannels - 1;
            for (int i = 0; i < encoderInfo.length; ++i) {
                encoderInfo[i] = SubframeEncoder.computeBest(samples[i], sampleDepth, opt);
            }
        } else {
            long[] left = samples[0];
            long[] right = samples[1];
            long[] mid = new long[samples[0].length];
            long[] side = new long[mid.length];
            for (int i = 0; i < mid.length; ++i) {
                mid[i] = left[i] + right[i] >> 1;
                side[i] = left[i] - right[i];
            }
            SizeEstimate<SubframeEncoder> leftInfo = SubframeEncoder.computeBest(left, sampleDepth, opt);
            SizeEstimate<SubframeEncoder> rightInfo = SubframeEncoder.computeBest(right, sampleDepth, opt);
            SizeEstimate<SubframeEncoder> midInfo = SubframeEncoder.computeBest(mid, sampleDepth, opt);
            SizeEstimate<SubframeEncoder> sideInfo = SubframeEncoder.computeBest(side, sampleDepth + 1, opt);
            long mode1Size = leftInfo.sizeEstimate + rightInfo.sizeEstimate;
            long mode8Size = leftInfo.sizeEstimate + sideInfo.sizeEstimate;
            long mode9Size = rightInfo.sizeEstimate + sideInfo.sizeEstimate;
            long mode10Size = midInfo.sizeEstimate + sideInfo.sizeEstimate;
            long minimum = Math.min(Math.min(mode1Size, mode8Size), Math.min(mode9Size, mode10Size));
            if (mode1Size == minimum) {
                enc.metadata.channelAssignment = 1;
                encoderInfo[0] = leftInfo;
                encoderInfo[1] = rightInfo;
            } else if (mode8Size == minimum) {
                enc.metadata.channelAssignment = 8;
                encoderInfo[0] = leftInfo;
                encoderInfo[1] = sideInfo;
            } else if (mode9Size == minimum) {
                enc.metadata.channelAssignment = 9;
                encoderInfo[0] = sideInfo;
                encoderInfo[1] = rightInfo;
            } else if (mode10Size == minimum) {
                enc.metadata.channelAssignment = 10;
                encoderInfo[0] = midInfo;
                encoderInfo[1] = sideInfo;
            } else {
                throw new AssertionError();
            }
        }
        long size = 0L;
        enc.subEncoders = new SubframeEncoder[encoderInfo.length];
        for (int i = 0; i < enc.subEncoders.length; ++i) {
            size += encoderInfo[i].sizeEstimate;
            enc.subEncoders[i] = (SubframeEncoder)encoderInfo[i].encoder;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try (BitOutputStream bitout = new BitOutputStream(bout);){
                enc.metadata.writeHeader(bitout);
            }
            bout.close();
            size += (long)(bout.toByteArray().length * 8);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        size = (size + 7L) / 8L;
        return new SizeEstimate<FrameEncoder>(size += 2L, enc);
    }

    public FrameEncoder(int sampleOffset, long[][] samples, int sampleDepth, int sampleRate) {
        this.metadata.sampleOffset = sampleOffset;
        this.metadata.sampleDepth = sampleDepth;
        this.metadata.sampleRate = sampleRate;
        this.metadata.blockSize = samples[0].length;
        this.metadata.channelAssignment = samples.length - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(long[][] samples, BitOutputStream out) throws IOException {
        Objects.requireNonNull(samples);
        Objects.requireNonNull(out);
        if (samples[0].length != this.metadata.blockSize) {
            throw new IllegalArgumentException();
        }
        this.metadata.writeHeader(out);
        int chanAsgn = this.metadata.channelAssignment;
        if (0 <= chanAsgn && chanAsgn <= 7) {
            for (int i = 0; i < samples.length; ++i) {
                this.subEncoders[i].encode(samples[i], out);
            }
        } else {
            if (8 > chanAsgn && chanAsgn > 10) throw new AssertionError();
            long[] left = samples[0];
            long[] right = samples[1];
            long[] mid = new long[this.metadata.blockSize];
            long[] side = new long[this.metadata.blockSize];
            for (int i = 0; i < this.metadata.blockSize; ++i) {
                mid[i] = left[i] + right[i] >> 1;
                side[i] = left[i] - right[i];
            }
            if (chanAsgn == 8) {
                this.subEncoders[0].encode(left, out);
                this.subEncoders[1].encode(side, out);
            } else if (chanAsgn == 9) {
                this.subEncoders[0].encode(side, out);
                this.subEncoders[1].encode(right, out);
            } else {
                if (chanAsgn != 10) throw new AssertionError();
                this.subEncoders[0].encode(mid, out);
                this.subEncoders[1].encode(side, out);
            }
        }
        out.alignToByte();
        out.writeInt(16, out.getCrc16());
    }
}

